/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.HTMLCodeOutput;
import java.applet.Applet;
import netscape.javascript.JSObject;

public class AppletCodeOutput
extends HTMLCodeOutput {
    private JSObject outputElement;
    private JSObject browserWindow;

    public AppletCodeOutput(Applet applet) {
        this.browserWindow = JSObject.getWindow((Applet)applet);
        try {
            JSObject doc = (JSObject)this.browserWindow.getMember("document");
            if (doc != null) {
                Object[] args = new Object[]{"SearchResults"};
                this.outputElement = (JSObject)doc.call("getElementById", args);
            }
        }
        catch (Exception e) {
            System.err.println("Cannot access the 'SearchResults' object: " + e.toString());
        }
    }

    public void flush() {
        try {
            boolean bOutputOK = false;
            String innerHTMLCode = this.getUTF8SafeCode(this.outputBuffer);
            if (this.outputElement != null) {
                this.outputElement.setMember("innerHTML", innerHTMLCode);
                bOutputOK = true;
            }
            if ((this.outputElement == null || this.outputElement.getMember("innerHTML") == null) && this.browserWindow != null) {
                this.browserWindow.call("ClearSearchResults", null);
                int totalChars = innerHTMLCode.length();
                int bufferLen = 1000;
                int position = 0;
                Object[] args = new Object[1];
                while (totalChars - position > 0) {
                    int charsToRead = Math.min(bufferLen, totalChars - position);
                    String codePart = innerHTMLCode.substring(position, position + charsToRead);
                    args[0] = codePart;
                    this.browserWindow.call("AddToSearchResults", args);
                    position += charsToRead;
                }
                this.browserWindow.call("ApplySearchResultsCode", null);
                bOutputOK = true;
            }
            if (!bOutputOK) {
                System.err.println("Cannot output search results.");
            }
            super.flush();
        }
        catch (Exception e) {
            System.err.println("Cannot output search results: " + e.toString());
        }
    }
}

