/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.AdvSearchNode;
import com.xtreeme.search.Int;
import com.xtreeme.search.Long;
import com.xtreeme.search.SDBInfo;
import com.xtreeme.search.SearchInfo;

public class SBKPostingIterator {
    static final int POSTINGSCACHESIZE = 8192;
    long offset;
    long lastOffset;
    int prevURLId;
    int lastURLId;
    int keywordId;
    int prevScore;
    int prevSection;
    int URLCount;
    byte[] cacheContents = new byte[8192];
    int cacheSize;
    int cachePtr;

    boolean refreshSBKCache(SDBInfo hsdb) {
        if (this.cacheSize - this.cachePtr < 6) {
            this.cacheSize = hsdb.readRawFully(this.offset, this.cacheContents);
            this.cachePtr = 0;
            return this.cacheSize > 0;
        }
        return false;
    }

    boolean initialize(SearchInfo si, AdvSearchNode node) {
        Int num32 = new Int();
        boolean bOK = false;
        if (node.nodeValue != 0) {
            this.offset = Long.make64BitValue(node.data32_1, node.data32_2);
            this.keywordId = node.nodeValue;
            this.prevURLId = 0;
            si.SBKPostingsDB.seek(this.offset + 8L);
            if (SDBInfo.getMultiByteNumber(si.SBKPostingsDB.file, 4, num32)) {
                this.lastOffset = this.offset + 8L + (long)num32.i - 1L;
                if (SDBInfo.getMultiByteNumber(si.SBKPostingsDB.file, 4, num32)) {
                    this.lastURLId = num32.i;
                    if (SDBInfo.getMultiByteNumber(si.SBKPostingsDB.file, 4, num32)) {
                        this.URLCount = num32.i;
                        this.cacheSize = 0;
                        this.cachePtr = 0;
                        this.offset += 20L;
                        bOK = this.refreshSBKCache(si.SBKPostingsDB);
                    }
                }
            }
        }
        return bOK;
    }

    boolean readVariableSizeInt(Int size, Int val) {
        byte bte;
        int nByte = 0;
        val.i = 0;
        do {
            bte = this.cacheContents[this.cachePtr];
            ++this.cachePtr;
            val.i |= (bte & 0x7F) << nByte * 7;
            ++nByte;
        } while ((bte & 0x80) != 0);
        size.i = nByte;
        return true;
    }

    int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    int readSectionsIntoLong(byte[] sections, int offset, int byteCount) {
        int retval = 0;
        int i = byteCount - 1;
        while (i >= 0) {
            retval = retval << 8 | this.unsignedByteToInt(sections[offset + i]);
            --i;
        }
        return retval;
    }

    boolean read(SDBInfo hsdb, int sectionsSize, Int id, Int score, Int section) {
        Int skipped = new Int();
        Int intVal = new Int();
        this.refreshSBKCache(hsdb);
        this.readVariableSizeInt(skipped, intVal);
        this.prevURLId += intVal.i;
        this.prevScore = this.cacheContents[this.cachePtr];
        this.prevSection = this.readSectionsIntoLong(this.cacheContents, this.cachePtr + 1, sectionsSize);
        this.cachePtr += 1 + sectionsSize;
        id.i = this.prevURLId;
        score.i = this.prevScore;
        section.i = this.prevSection;
        this.offset += (long)(skipped.i + 1 + sectionsSize);
        return true;
    }
}

