/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.Bitfield16Record;
import com.xtreeme.search.Bitfield24_32Record;
import com.xtreeme.search.Bitfield24_32_64Record;
import com.xtreeme.search.Bitfield24_8Record;
import com.xtreeme.search.Bitfield24_8_8Record;
import com.xtreeme.search.CharRecord;
import com.xtreeme.search.Int;
import com.xtreeme.search.Record;
import com.xtreeme.search.URLIndexRecord;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessControlException;

public class SDBInfo {
    public static final int SDBRT_URLINDEX = 0;
    public static final int SDBRT_CHAR = 1;
    public static final int SDBRT_16 = 2;
    public static final int SDBRT_24_8 = 3;
    public static final int SDBRT_24_32 = 4;
    public static final int SDBRT_CONTENTS = 5;
    public static final int SDBRT_24_8_8 = 6;
    public static final int SDBRT_24_32_64 = 7;
    public static final int SDBRT_OTHER = 8;
    RandomAccessFile file;
    private int recordSize;
    private int recordType;
    private long pos;

    boolean initialize(String filePath, int recSize, int recType) {
        try {
            this.file = new RandomAccessFile(filePath, "r");
            this.file.seek(0L);
            this.pos = 0L;
            this.recordType = recType;
            this.recordSize = recSize;
            return true;
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: cannot read file " + filePath);
        }
        catch (IOException e) {
            System.err.println("Error: error reading file " + filePath);
        }
        catch (AccessControlException e) {
            System.err.println("Error: no access to read file " + filePath);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Error: error reading file " + filePath + " (out of bounds exception)");
        }
        catch (Exception e) {
            System.err.println("Error: opening file " + filePath);
        }
        this.cleanUp();
        return false;
    }

    long getSize() {
        if (this.isInitialized()) {
            try {
                return this.file.length() / (long)this.recordSize;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    long getPos() {
        return this.pos;
    }

    boolean isInitialized() {
        return this.file != null && this.recordSize > 0;
    }

    void cleanUp() {
        try {
            this.file.close();
            this.file = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean seek(long position) {
        if (position > this.getSize() || position < 0L) {
            return false;
        }
        try {
            this.file.seek((long)this.recordSize * position);
        }
        catch (Exception e) {
            return false;
        }
        this.pos = position;
        return true;
    }

    int readRawFully(long byteOffset, byte[] buffer) {
        try {
            this.file.seek(byteOffset);
            return this.file.read(buffer);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static boolean getMultiByteNumber(RandomAccessFile file, int byteCount, Int number) {
        int retval = 0;
        byte[] bytes = new byte[byteCount];
        try {
            file.readFully(bytes);
        }
        catch (Exception e) {
            return false;
        }
        int i = byteCount - 1;
        while (i >= 0) {
            retval = retval << 8 | bytes[i] & 0xFF;
            --i;
        }
        number.i = retval;
        return true;
    }

    boolean get(Record record) {
        switch (this.recordType) {
            case 1: {
                try {
                    char c;
                    int item = this.file.readByte() & 0xFF;
                    ((CharRecord)record).c = c = (char)item;
                }
                catch (Exception item) {}
                break;
            }
            case 2: {
                try {
                    int item2;
                    int item1;
                    ((Bitfield16Record)record).data8_1 = item1 = this.file.readByte() & 0xFF;
                    ((Bitfield16Record)record).data8_2 = item2 = this.file.readByte() & 0xFF;
                }
                catch (Exception item1) {}
                break;
            }
            case 4: {
                Int d24 = new Int();
                Int d8 = new Int();
                Int d32 = new Int();
                if (!SDBInfo.getMultiByteNumber(this.file, 3, d24) || !SDBInfo.getMultiByteNumber(this.file, 1, d8) || !SDBInfo.getMultiByteNumber(this.file, 4, d32)) break;
                ((Bitfield24_32Record)record).data24 = d24.i;
                ((Bitfield24_32Record)record).data32 = d32.i;
                break;
            }
            case 7: {
                Int d24 = new Int();
                Int d8 = new Int();
                Int d32 = new Int();
                Int d64_1 = new Int();
                Int d64_2 = new Int();
                if (!SDBInfo.getMultiByteNumber(this.file, 3, d24) || !SDBInfo.getMultiByteNumber(this.file, 1, d8) || !SDBInfo.getMultiByteNumber(this.file, 4, d32) || !SDBInfo.getMultiByteNumber(this.file, 4, d64_1) || !SDBInfo.getMultiByteNumber(this.file, 4, d64_2)) break;
                ((Bitfield24_32_64Record)record).data24 = d24.i;
                ((Bitfield24_32_64Record)record).data32 = d32.i;
                ((Bitfield24_32_64Record)record).data64_p1 = d64_1.i;
                ((Bitfield24_32_64Record)record).data64_p2 = d64_2.i;
                break;
            }
            case 3: {
                Int d24 = new Int();
                Int d8 = new Int();
                if (!SDBInfo.getMultiByteNumber(this.file, 3, d24) || !SDBInfo.getMultiByteNumber(this.file, 1, d8)) break;
                ((Bitfield24_8Record)record).data24 = d24.i;
                ((Bitfield24_8Record)record).data8 = d8.i;
                break;
            }
            case 6: {
                Int d24 = new Int();
                Int d8_1 = new Int();
                Int d8_2 = new Int();
                if (!SDBInfo.getMultiByteNumber(this.file, 3, d24) || !SDBInfo.getMultiByteNumber(this.file, 1, d8_1) || !SDBInfo.getMultiByteNumber(this.file, 1, d8_2)) break;
                ((Bitfield24_8_8Record)record).data24 = d24.i;
                ((Bitfield24_8_8Record)record).data8_1 = d8_1.i;
                ((Bitfield24_8_8Record)record).data8_2 = d8_2.i;
                break;
            }
            case 0: {
                Int d24 = new Int();
                Int d8 = new Int();
                Int d32 = new Int();
                Int d16_1 = new Int();
                Int d16_2 = new Int();
                if (!SDBInfo.getMultiByteNumber(this.file, 3, d24) || !SDBInfo.getMultiByteNumber(this.file, 1, d8) || !SDBInfo.getMultiByteNumber(this.file, 4, d32) || !SDBInfo.getMultiByteNumber(this.file, 2, d16_1) || !SDBInfo.getMultiByteNumber(this.file, 2, d16_2)) break;
                ((URLIndexRecord)record).data24 = d24.i;
                ((URLIndexRecord)record).sizeFlags = d8.i & 3;
                ((URLIndexRecord)record).sizeFraction = (d8.i & 0x3C) >> 2;
                ((URLIndexRecord)record).data32 = d32.i;
                ((URLIndexRecord)record).dateYear = d16_1.i & 0xFFF;
                ((URLIndexRecord)record).dateMonth = (d16_1.i & 0xF000) >> 12;
                ((URLIndexRecord)record).dateDay = d16_2.i & 0x1F;
                ((URLIndexRecord)record).sizeMain = (d16_2.i & 0xFFE0) >> 5;
                break;
            }
            default: {
                return false;
            }
        }
        ++this.pos;
        return true;
    }

    boolean getAt(int pos, Record record) {
        if (!this.seek(pos)) {
            return false;
        }
        return this.get(record);
    }
}

