/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.Bitfield24_8Record;
import com.xtreeme.search.General;
import com.xtreeme.search.IndexPosInfo;
import com.xtreeme.search.Int;
import com.xtreeme.search.KeywordInfo;
import com.xtreeme.search.KeywordLocationInfo;
import com.xtreeme.search.ResultInfo;
import com.xtreeme.search.SearchFilter;
import com.xtreeme.search.SearchInfo;
import com.xtreeme.search.Str;
import com.xtreeme.search.URLIndexInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

abstract class SearchEngineBase {
    SearchInfo si;
    int minKeywordLength;
    int maxResults;
    SearchFilter searchFilter;
    String prefixString;
    static final int MAXSTR = 2048;
    private static final int CONTENTS_KEYWORD_LIMIT_SOURCE = 3000;
    private static final int CONTENTS_KEYWORD_LIMIT_TARGET = 30;
    private static final int CONTENTS_NEIGHBORING_KEYWORDS_BOOST = 10;

    SearchEngineBase(SearchInfo searchInfo, int minLength, int maxResultCount, String prefix, SearchFilter filter) {
        this.si = searchInfo;
        this.minKeywordLength = minLength;
        this.searchFilter = filter;
        this.maxResults = maxResultCount;
        this.prefixString = prefix;
    }

    static boolean isTerminatingCharacter(char character, int codepage) {
        char ch = character;
        if (ch >= '\u0000' && ch <= '&' || ch >= '\'' && ch <= '/' || ch >= ':' && ch <= '@' || ch >= '[' && ch <= '^' || ch == '`' || ch >= '{' && ch <= '~') {
            return true;
        }
        return codepage != 65001 && ch >= '\u0080' && ch <= '\u00bf';
    }

    static boolean checkSpecialCharacter(String str, int pos, char[] specialChars, Str translatedText, Int skipChars) {
        if (specialChars == null || specialChars[0] == '\u0000') {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < 91) {
            skipChars.i = 0;
            int curPos = pos;
            if (specialChars[i * 14] == '\u0000') break;
            int j = 0;
            while (curPos < len && specialChars[i * 14 + j] == str.charAt(curPos)) {
                ++skipChars.i;
                ++curPos;
                ++j;
            }
            if (specialChars[i * 14 + j] == '\u0000') {
                j = i * 14 + 7;
                while (specialChars[j] != '\u0000') {
                    translatedText.s = String.valueOf(translatedText.s) + specialChars[j];
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    static void markExpressionNonBold(int expressionStartIndex, int expressionEndIndex, List keywordLocationList) {
        ListIterator iterator = keywordLocationList.listIterator(expressionStartIndex);
        int index = expressionStartIndex;
        while (iterator.hasNext() && index <= expressionEndIndex) {
            KeywordLocationInfo info = (KeywordLocationInfo)iterator.next();
            info.bMarkBold = false;
            System.err.println("marknonbold" + info.ID + " p:" + info.position);
            ++index;
        }
    }

    static void removeIncompleteExpressionsFromLocationList(List keywordLocationList) {
        KeywordLocationInfo prevInfo = null;
        Iterator iterator = keywordLocationList.iterator();
        int expressionStart = -1;
        int prevIterator = 0;
        int curIterator = 0;
        while (iterator.hasNext()) {
            KeywordLocationInfo info = (KeywordLocationInfo)iterator.next();
            if (expressionStart != -1 && prevInfo != null && (info.expressionId != prevInfo.expressionId || info.expressionPos != prevInfo.expressionPos + 1 || info.prevKeywordPosition > prevInfo.position)) {
                System.err.println("beforemark" + info.expressionId + " P:" + info.expressionPos);
                if (info.expressionPos == 1) {
                    SearchEngineBase.markExpressionNonBold(expressionStart, prevIterator, keywordLocationList);
                } else {
                    SearchEngineBase.markExpressionNonBold(expressionStart, curIterator, keywordLocationList);
                }
                expressionStart = -1;
            }
            if (info.expressionPos > 1 && expressionStart == -1) {
                info.bMarkBold = false;
            } else if (info.expressionPos == 1) {
                expressionStart = curIterator;
            } else if (info.bExpressionEnd) {
                expressionStart = -1;
            }
            prevInfo = info;
            prevIterator = curIterator++;
        }
        if (expressionStart != -1) {
            int tailIndex = keywordLocationList.size() - 1;
            System.err.println("markafter");
            KeywordLocationInfo tailInfo = (KeywordLocationInfo)keywordLocationList.get(tailIndex);
            if (!tailInfo.bExpressionEnd) {
                SearchEngineBase.markExpressionNonBold(expressionStart, tailIndex, keywordLocationList);
                expressionStart = -1;
            }
        }
    }

    static boolean findKeywordsInContents(SearchInfo si, int startPos, int keywordCount, List keywordList, List keywordLocationList) {
        int insertedCount = 0;
        int firstKeywordID = 0;
        int prevKeywordPosition = 0;
        int nextKeywordIterator = 0;
        int nextKeywordID = 0;
        if (si.contentsDB.seek(startPos)) {
            int i = 0;
            while (i < keywordCount && i < 3000) {
                int currentPosition = startPos + i;
                if (insertedCount >= 30) break;
                Bitfield24_8Record dataRecord = new Bitfield24_8Record();
                si.contentsDB.get(dataRecord);
                int keywordID = dataRecord.data24;
                if (i == 0) {
                    firstKeywordID = keywordID;
                }
                if ((dataRecord.data8 & 1) == 1) {
                    ListIterator it;
                    if (nextKeywordID != 0 && nextKeywordID == keywordID && nextKeywordIterator != 0) {
                        it = keywordList.listIterator(nextKeywordIterator);
                        System.err.println("using shortcut in iteration");
                    } else {
                        it = keywordList.listIterator();
                    }
                    nextKeywordID = 0;
                    int curPos = 0;
                    while (it.hasNext()) {
                        KeywordInfo keywordInfo = (KeywordInfo)it.next();
                        if (keywordInfo.ID == keywordID && keywordID != 0) {
                            KeywordLocationInfo keywordLocation = new KeywordLocationInfo();
                            keywordLocation.ID = keywordID;
                            keywordLocation.position = currentPosition;
                            keywordLocation.bMarkBold = true;
                            keywordLocation.expressionPos = keywordInfo.expressionPos;
                            keywordLocation.expressionId = keywordInfo.expressionId;
                            keywordLocation.bExpressionEnd = keywordInfo.bExpressionEnd;
                            keywordLocation.prevKeywordPosition = prevKeywordPosition;
                            keywordLocation.score = 0;
                            keywordLocation.bDisplayed = false;
                            keywordLocationList.add(keywordLocation);
                            ++insertedCount;
                            if (keywordInfo.expressionId == 0) break;
                            nextKeywordID = 0;
                            if (!it.hasNext()) break;
                            nextKeywordIterator = curPos + 1;
                            keywordInfo = (KeywordInfo)it.next();
                            nextKeywordID = keywordInfo.ID;
                            break;
                        }
                        ++curPos;
                    }
                    prevKeywordPosition = currentPosition;
                }
                ++i;
            }
            SearchEngineBase.removeIncompleteExpressionsFromLocationList(keywordLocationList);
            if (keywordLocationList.size() == 0) {
                KeywordLocationInfo keywordLocation = new KeywordLocationInfo();
                keywordLocation.ID = firstKeywordID;
                keywordLocation.position = startPos;
                keywordLocation.score = 0;
                keywordLocation.prevKeywordPosition = 0;
                keywordLocation.expressionId = 0;
                keywordLocation.bMarkBold = false;
                keywordLocation.bDisplayed = false;
                keywordLocationList.add(keywordLocation);
            }
            return true;
        }
        return false;
    }

    static boolean filterKeywordsInContents(int maxDescriptionLength, List keywordLocationList, int contentPreviewBlockSize) {
        int maxScore = 0;
        int wordsLeft = maxDescriptionLength;
        int markNextKeywords = 0;
        KeywordLocationInfo prevInfo = null;
        boolean bAnythingMarkedBold = false;
        ListIterator it = keywordLocationList.listIterator();
        while (it.hasNext()) {
            it.next();
        }
        while (it.hasPrevious()) {
            KeywordLocationInfo keywordInfo = (KeywordLocationInfo)it.previous();
            if (keywordInfo.bMarkBold) {
                bAnythingMarkedBold = true;
            }
            if (prevInfo != null) {
                if (prevInfo.position - keywordInfo.position <= contentPreviewBlockSize) {
                    keywordInfo.score = prevInfo.score + 1;
                    if (prevInfo.position - keywordInfo.position == 1) {
                        keywordInfo.score += 10;
                    }
                } else {
                    keywordInfo.score = 1;
                }
            } else {
                keywordInfo.score = 1;
            }
            if (keywordInfo.score > maxScore) {
                maxScore = keywordInfo.score;
            }
            prevInfo = keywordInfo;
        }
        int i = maxScore;
        while (i >= 1) {
            if (wordsLeft <= 0) break;
            for (KeywordLocationInfo keywordInfo : keywordLocationList) {
                if (!keywordInfo.bMarkBold && bAnythingMarkedBold || keywordInfo.score != i && markNextKeywords <= 0 || keywordInfo.bDisplayed) continue;
                keywordInfo.bDisplayed = true;
                markNextKeywords = keywordInfo.score - 1;
                if ((wordsLeft -= contentPreviewBlockSize) <= 0) break;
            }
            --i;
        }
        return true;
    }

    static boolean shouldMakeDescriptionKeywordBold(int pos, ListIterator markedWordsIterator) {
        while (markedWordsIterator.hasNext()) {
            KeywordLocationInfo info = (KeywordLocationInfo)markedWordsIterator.next();
            if (info != null && info.position > pos) {
                markedWordsIterator.previous();
                return false;
            }
            if (info.position != pos) continue;
            markedWordsIterator.previous();
            return info.bMarkBold;
        }
        return false;
    }

    static boolean addContentWordsToDescription(SearchInfo si, List keywordList, int pos, int count, ListIterator markedWordsIterator, Int charsLeft, Str buffer) {
        boolean bNonKeywordMode = false;
        boolean bMakeBold = false;
        if (si.contentsDB.seek(pos)) {
            int i = 0;
            while (i < count) {
                Bitfield24_8Record record = new Bitfield24_8Record();
                si.contentsDB.get(record);
                int keywordID = record.data24;
                String keywordBuffer = new String();
                boolean bSpaceBefore = (record.data8 & 8) == 0;
                int wordCase = (record.data8 & 6) >> 1;
                if ((record.data8 & 1) != 1) {
                    bNonKeywordMode = true;
                }
                if (charsLeft.i <= 0) break;
                if (bNonKeywordMode) {
                    int j = 0;
                    while (j < 3 && charsLeft.i > 1) {
                        char str = (char)((record.data24 & 255 << 8 * j) >> 8 * j);
                        if (j == 0 && bSpaceBefore) {
                            buffer.s = String.valueOf(buffer.s) + ' ';
                            --charsLeft.i;
                        }
                        if (str == '\u0000') {
                            bNonKeywordMode = false;
                            break;
                        }
                        if (str == '<') {
                            buffer.s = String.valueOf(buffer.s) + "&lt;";
                            charsLeft.i -= 4;
                        } else if (str == '>') {
                            buffer.s = String.valueOf(buffer.s) + "&gt;";
                            charsLeft.i -= 4;
                        } else {
                            buffer.s = String.valueOf(buffer.s) + str;
                            --charsLeft.i;
                        }
                        ++j;
                    }
                } else if (keywordID == 0) {
                    bNonKeywordMode = true;
                } else {
                    Str keywordBufferObj = new Str();
                    if (SearchInfo.searchFindStringNameFromId(si.keywordIndex2DB, si.keywordDB, keywordID, keywordBufferObj, false)) {
                        keywordBuffer = keywordBufferObj.s;
                        int keywordLength = keywordBuffer.length();
                        keywordBuffer = Str.fixWordCase(wordCase, keywordBuffer);
                        bMakeBold = SearchEngineBase.shouldMakeDescriptionKeywordBold(pos + i, markedWordsIterator);
                        if (bSpaceBefore && charsLeft.i > 1) {
                            buffer.s = String.valueOf(buffer.s) + ' ';
                            --charsLeft.i;
                        }
                        if (bMakeBold && charsLeft.i > 16) {
                            buffer.s = String.valueOf(buffer.s) + "<span class='b'>";
                            charsLeft.i -= 16;
                        }
                        if (keywordLength < charsLeft.i) {
                            buffer.s = String.valueOf(buffer.s) + keywordBuffer;
                            charsLeft.i -= keywordLength;
                        } else {
                            charsLeft.i = 0;
                            break;
                        }
                        if (bMakeBold && charsLeft.i > 7) {
                            buffer.s = String.valueOf(buffer.s) + "</span>";
                            charsLeft.i -= 7;
                        }
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static boolean createContentsDescription(SearchInfo si, int contentPreviewBlockCount, int contentPreviewBlockSize, List keywordLocationList, List keywordList, int startPos, int keywordCount, Str buffer) {
        int maxDescriptionLength = contentPreviewBlockCount * contentPreviewBlockSize;
        int lastPos = -1;
        int charsLeft = 2047;
        int updatedBlockSize = contentPreviewBlockSize;
        if (keywordLocationList.size() > 0 && keywordLocationList.size() * contentPreviewBlockSize < maxDescriptionLength) {
            updatedBlockSize = maxDescriptionLength / keywordLocationList.size();
        }
        int lastCount = updatedBlockSize;
        Iterator it = keywordLocationList.iterator();
        ListIterator markedWordsIterator = keywordLocationList.listIterator();
        while (it.hasNext()) {
            int count;
            KeywordLocationInfo keywordInfo = (KeywordLocationInfo)it.next();
            if (!keywordInfo.bDisplayed) continue;
            int pos = keywordInfo.position - updatedBlockSize / 2;
            if (pos < startPos) {
                pos = startPos;
            }
            if (lastPos != -1 && pos - lastPos < lastCount) {
                pos = lastPos + lastCount;
                count = keywordInfo.position + updatedBlockSize / 2 + 1 - pos;
            } else {
                count = updatedBlockSize;
            }
            if (count <= 0) continue;
            if (pos + count > startPos + keywordCount) {
                count = startPos + keywordCount - pos;
            }
            if (lastPos == -1 || pos - lastPos > lastCount) {
                buffer.s = String.valueOf(buffer.s) + " ...";
                if (4 < charsLeft) {
                    charsLeft -= 4;
                }
            }
            Int charsLeftObj = new Int(charsLeft);
            SearchEngineBase.addContentWordsToDescription(si, keywordList, pos, count, markedWordsIterator, charsLeftObj, buffer);
            charsLeft = charsLeftObj.i;
            lastPos = pos;
            lastCount = count;
        }
        return true;
    }

    static boolean getDescriptionFromContents(SearchInfo si, List keywordList, int URLID, int contentPreviewBlockCount, int contentPreviewBlockSize, Str buffer) {
        ArrayList keywordLocationList;
        int count;
        boolean retval = false;
        IndexPosInfo indexPosInfo = new IndexPosInfo();
        boolean bSearchRecord = SearchInfo.searchFindPosIn24_32Index(si.contentsIndexDB, URLID, indexPosInfo);
        if (bSearchRecord && SearchEngineBase.findKeywordsInContents(si, indexPosInfo.startPos, count = indexPosInfo.endPos == -1 ? (int)si.contentsDB.getSize() - indexPosInfo.startPos : indexPosInfo.endPos - indexPosInfo.startPos, keywordList, keywordLocationList = new ArrayList()) && SearchEngineBase.filterKeywordsInContents(contentPreviewBlockCount * contentPreviewBlockSize, keywordLocationList, contentPreviewBlockSize)) {
            SearchEngineBase.createContentsDescription(si, contentPreviewBlockCount, contentPreviewBlockSize, keywordLocationList, keywordList, indexPosInfo.startPos, count, buffer);
            retval = true;
        }
        return retval;
    }

    static boolean searchAddResult(SearchInfo si, int URLID, int score, int sortType, SearchFilter searchFilter, List resultList) {
        URLIndexInfo indexInfo = new URLIndexInfo();
        if (!SearchInfo.searchFindPosInURLIndex(si.URLIndexDB, URLID, indexInfo)) {
            return false;
        }
        ResultInfo result = new ResultInfo();
        result.dateYear = indexInfo.dateYear;
        result.dateMonth = indexInfo.dateMonth;
        result.dateDay = indexInfo.dateDay;
        result.sizeFlags = indexInfo.sizeFlags;
        result.sizeFraction = indexInfo.sizeFraction;
        result.sizeMain = indexInfo.sizeMain;
        result.URL = General.readStringFromFile(si.URLDB.file, indexInfo.startPos);
        result.URLID = URLID;
        result.score = score;
        result.setDocType(ResultInfo.getDocTypeFromURL(result.URL, !si.bDemoVersion));
        if (ResultInfo.checkResultAgainstFilter(si.bDemoVersion, result, searchFilter)) {
            resultList.add(result);
        }
        return true;
    }

    public abstract boolean searchStart(String var1, int var2, char[] var3, ArrayList var4, ArrayList var5, int var6);
}

