/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.Bitfield24_32Record;
import com.xtreeme.search.Bitfield24_32_64Record;
import com.xtreeme.search.General;
import com.xtreeme.search.IndexPosInfo;
import com.xtreeme.search.Int;
import com.xtreeme.search.KeywordDetails;
import com.xtreeme.search.Record;
import com.xtreeme.search.ResultInfo;
import com.xtreeme.search.SDBInfo;
import com.xtreeme.search.SearchIndex_StrInfoRecord;
import com.xtreeme.search.SearchSettings;
import com.xtreeme.search.Str;
import com.xtreeme.search.URLIndexInfo;
import com.xtreeme.search.URLIndexRecord;
import java.util.List;

public class SearchInfo {
    private static final String KEYWORDDBNAME = "db1.sdb";
    private static final String URLDBNAME = "db2.sdb";
    private static final String KEYWORDINDEXDBNAME = "db5.sdb";
    private static final String URLINDEXDBNAME = "db6.sdb";
    private static final String CONTENTSDBNAME = "db7.sdb";
    private static final String CONTENTSINDEXDBNAME = "db8.sdb";
    private static final String KEYWORDINDEX2DBNAME = "db9.sdb";
    private static final String POSITIONSBYURLINDEX1DBNAME = "db10.sdb";
    private static final String POSITIONSBYURLINDEX2DBNAME = "db11.sdb";
    private static final String POSITIONSBYURLDBNAME = "db12.sdb";
    private static final String SBKPOSTINGSDBNAME = "db13.sdb";
    SDBInfo keywordDB;
    SDBInfo keywordIndexDB;
    SDBInfo URLDB;
    SDBInfo URLIndexDB;
    SDBInfo keywordIndex2DB;
    SDBInfo contentsIndexDB;
    SDBInfo contentsDB;
    SDBInfo positionsByURLIndex1DB;
    SDBInfo positionsByURLIndex2DB;
    SDBInfo positionsByURLDB;
    SDBInfo SBKPostingsDB;
    SearchSettings settings;
    boolean bDemoVersion;

    public boolean initialize(String dataPath, String inputPrefixString, SearchSettings searchSettings) {
        String prefixString;
        block4: {
            prefixString = inputPrefixString;
            if (prefixString == null) {
                prefixString = new String();
            }
            this.keywordDB = new SDBInfo();
            this.keywordIndexDB = new SDBInfo();
            this.URLDB = new SDBInfo();
            this.URLIndexDB = new SDBInfo();
            this.keywordIndex2DB = new SDBInfo();
            this.SBKPostingsDB = new SDBInfo();
            this.contentsIndexDB = new SDBInfo();
            this.contentsDB = new SDBInfo();
            this.positionsByURLIndex1DB = new SDBInfo();
            this.positionsByURLIndex2DB = new SDBInfo();
            this.positionsByURLDB = new SDBInfo();
            this.settings = searchSettings;
            try {
                if (this.keywordDB.initialize(String.valueOf(dataPath) + prefixString + KEYWORDDBNAME, 1, 1) && this.SBKPostingsDB.initialize(String.valueOf(dataPath) + prefixString + SBKPOSTINGSDBNAME, 1, 1) && this.URLDB.initialize(String.valueOf(dataPath) + prefixString + URLDBNAME, 1, 1) && this.URLIndexDB.initialize(String.valueOf(dataPath) + prefixString + URLINDEXDBNAME, 12, 0) && this.keywordIndexDB.initialize(String.valueOf(dataPath) + prefixString + KEYWORDINDEXDBNAME, 16, 7)) break block4;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        this.contentsIndexDB.initialize(String.valueOf(dataPath) + prefixString + CONTENTSINDEXDBNAME, 8, 4);
        this.contentsDB.initialize(String.valueOf(dataPath) + prefixString + CONTENTSDBNAME, 4, 3);
        this.keywordIndex2DB.initialize(String.valueOf(dataPath) + prefixString + KEYWORDINDEX2DBNAME, 8, 4);
        this.positionsByURLIndex1DB.initialize(String.valueOf(dataPath) + prefixString + POSITIONSBYURLINDEX1DBNAME, 8, 4);
        this.positionsByURLIndex2DB.initialize(String.valueOf(dataPath) + prefixString + POSITIONSBYURLINDEX2DBNAME, 8, 4);
        this.positionsByURLDB.initialize(String.valueOf(dataPath) + prefixString + POSITIONSBYURLDBNAME, 2, 2);
        return true;
    }

    public void setDemoVersion(boolean bDemo) {
        this.bDemoVersion = bDemo;
    }

    public void cleanUp() {
        this.keywordDB.cleanUp();
        this.keywordIndexDB.cleanUp();
        this.URLDB.cleanUp();
        this.URLIndexDB.cleanUp();
        this.keywordIndex2DB.cleanUp();
        this.SBKPostingsDB.cleanUp();
        this.contentsIndexDB.cleanUp();
        this.contentsDB.cleanUp();
        this.positionsByURLIndex1DB.cleanUp();
        this.positionsByURLIndex2DB.cleanUp();
        this.positionsByURLDB.cleanUp();
    }

    static boolean searchFindStringNameFromId(SDBInfo indexDB, SDBInfo stringDB, int id, Str searchString, boolean bTranslated) {
        IndexPosInfo indexInfo = new IndexPosInfo();
        if (!SearchInfo.searchFindPosIn24_32Index(indexDB, id, indexInfo)) {
            return false;
        }
        searchString.s = new String();
        searchString.s = General.readStringFromFile(stringDB.file, indexInfo.startPos);
        if (!bTranslated) {
            int newStartPos;
            if (indexInfo.endPos == -1) {
                indexInfo.endPos = (int)stringDB.getSize();
            }
            if ((newStartPos = indexInfo.startPos + searchString.s.length() + 1) < indexInfo.endPos) {
                searchString.s = General.readStringFromFile(stringDB.file, newStartPos);
            }
        }
        return true;
    }

    static boolean searchFindStringIdFromName(SDBInfo indexDB, SDBInfo stringDB, String searchString, Int id) {
        KeywordDetails info = new KeywordDetails();
        boolean bOK = SearchInfo.searchFindStringDetailsFromNameEx(searchString, info, null, indexDB, stringDB);
        id.i = info.keywordId;
        return bOK;
    }

    static boolean searchFindStringDetailsFromNameEx(String searchString, KeywordDetails info, Int recordPos, SDBInfo indexDB, SDBInfo stringDB) {
        SearchIndex_StrInfoRecord searchInfo = new SearchIndex_StrInfoRecord();
        searchInfo.stringDB = stringDB;
        searchInfo.searchString = searchString;
        Bitfield24_32_64Record record = new Bitfield24_32_64Record();
        Int dummy = new Int();
        int pos = SearchInfo.SDBBinarySearch(indexDB, searchInfo, record, 0, (int)indexDB.getSize() - 1, dummy, 0);
        if (pos == -1) {
            info.data1 = 0;
            info.data2 = 0;
            info.keywordId = 0;
            return false;
        }
        info.keywordId = record.data24;
        info.data1 = record.data64_p1;
        info.data2 = record.data64_p2;
        info.keyword = searchString;
        if (recordPos != null) {
            recordPos.i = pos;
        }
        return true;
    }

    int getKeywordIdFromString(String keywordString) {
        Int id = new Int();
        if (SearchInfo.searchFindStringIdFromName(this.keywordIndexDB, this.keywordDB, keywordString, id)) {
            return id.i;
        }
        return 0;
    }

    static boolean searchFindStringNameAndIDFromPos(int pos, Str searchString, Int id, Int data1, Int data2, SDBInfo indexDB, SDBInfo stringDB) {
        Bitfield24_32_64Record record = new Bitfield24_32_64Record();
        if (indexDB.seek(pos)) {
            indexDB.get(record);
            id.i = record.data24;
            data1.i = record.data64_p1;
            data2.i = record.data64_p2;
            int stringPos = record.data32;
            searchString.s = General.readStringFromFile(stringDB.file, stringPos);
            return true;
        }
        return false;
    }

    boolean getKeywordsFromWildcardString(String wildcardStr, int minKeywordLength, int maxKeywordCount, List wildcardKeywords) {
        Bitfield24_32_64Record record = new Bitfield24_32_64Record();
        int startPos = 0;
        int endPos = (int)this.keywordIndexDB.getSize();
        SearchIndex_StrInfoRecord searchInfo = new SearchIndex_StrInfoRecord();
        int keywordCount = 0;
        String prefix = new String();
        int len = wildcardStr.length();
        int i = 0;
        while (i < len) {
            char ch = wildcardStr.charAt(i);
            if (ch == '*' || ch == '?') break;
            prefix = String.valueOf(prefix) + ch;
            ++i;
        }
        if (prefix.length() > 0) {
            searchInfo.stringDB = this.keywordDB;
            searchInfo.searchString = prefix;
            Int intVal = new Int();
            SearchInfo.SDBBinarySearch(this.keywordIndexDB, searchInfo, record, 0, (int)this.keywordIndexDB.getSize() - 1, intVal, 0);
            startPos = intVal.i;
            searchInfo.stringDB = this.keywordDB;
            char lastCh = (char)(Character.toLowerCase(prefix.charAt(prefix.length() - 1)) + '\u0001');
            searchInfo.searchString = String.valueOf(prefix.substring(0, prefix.length() - 1)) + lastCh;
            SearchInfo.SDBBinarySearch(this.keywordIndexDB, searchInfo, record, 0, (int)this.keywordIndexDB.getSize() - 1, intVal, 0);
            endPos = intVal.i;
        }
        int pos = startPos;
        Int currentData1 = new Int();
        Int currentData2 = new Int();
        while ((long)pos < this.keywordIndexDB.getSize() && pos <= endPos && keywordCount < maxKeywordCount) {
            Str currentKeyword = new Str();
            Int currentKeywordID = new Int();
            if (!SearchInfo.searchFindStringNameAndIDFromPos(pos, currentKeyword, currentKeywordID, currentData1, currentData2, this.keywordIndexDB, this.keywordDB)) break;
            if (currentKeyword.s.length() >= minKeywordLength && Str.compareStringWithWildcardString(currentKeyword.s, wildcardStr)) {
                KeywordDetails keywordDetails = new KeywordDetails();
                keywordDetails.keywordId = currentKeywordID.i;
                keywordDetails.data1 = currentData1.i;
                keywordDetails.data2 = currentData2.i;
                keywordDetails.keyword = currentKeyword.s;
                wildcardKeywords.add(keywordDetails);
                ++keywordCount;
            }
            ++pos;
        }
        return true;
    }

    static boolean searchFindPosIn24_32IndexEx(SDBInfo hsdb, IndexPosInfo info, int ID, int first, int last, Int indexPos) {
        Bitfield24_32Record compRecord = new Bitfield24_32Record();
        compRecord.data24 = ID;
        Bitfield24_32Record record = new Bitfield24_32Record();
        int pos = SearchInfo.SDBBinarySearch(hsdb, compRecord, record, first, last, indexPos, 0);
        if (pos == -1) {
            info.startPos = -1;
            return false;
        }
        info.startPos = record.data32;
        if (hsdb.getPos() == hsdb.getSize()) {
            info.endPos = -1;
            return true;
        }
        hsdb.get(record);
        info.endPos = record.data32;
        return true;
    }

    static boolean searchFindPosIn24_32Index(SDBInfo hsdb, int ID, IndexPosInfo info) {
        Int indexPos = new Int();
        return SearchInfo.searchFindPosIn24_32IndexEx(hsdb, info, ID, 0, (int)hsdb.getSize() - 1, indexPos);
    }

    static boolean searchFindPosInURLIndex(SDBInfo hsdb, int ID, URLIndexInfo info) {
        Int dummy = new Int();
        URLIndexRecord record = new URLIndexRecord();
        URLIndexRecord compRecord = new URLIndexRecord();
        compRecord.data24 = ID;
        int pos = SearchInfo.SDBBinarySearch(hsdb, compRecord, record, 0, (int)hsdb.getSize() - 1, dummy, 0);
        if (pos == -1) {
            info.startPos = -1;
            return false;
        }
        info.startPos = record.data32;
        info.dateYear = record.dateYear;
        info.dateMonth = record.dateMonth;
        info.dateDay = record.dateDay;
        info.sizeFlags = record.sizeFlags;
        info.sizeFraction = record.sizeFraction;
        info.sizeMain = record.sizeMain;
        if (hsdb.getPos() == hsdb.getSize()) {
            info.endPos = -1;
            return true;
        }
        hsdb.get(record);
        info.endPos = record.data32;
        return true;
    }

    boolean getURLStrings(int URLID, ResultInfo info) {
        URLIndexInfo indexInfo = new URLIndexInfo();
        if (!SearchInfo.searchFindPosInURLIndex(this.URLIndexDB, URLID, indexInfo)) {
            return false;
        }
        String URL2 = General.readStringFromFile(this.URLDB.file, indexInfo.startPos);
        int off = URL2.length() + 1;
        info.sections = new String[this.settings.sectionsCount];
        info.sectionsCount = this.settings.sectionsCount;
        int i = 0;
        while (i < this.settings.sectionsCount) {
            info.sections[i] = General.readStringFromFile(this.URLDB.file, indexInfo.startPos + off);
            off += info.sections[i].length() + 1;
            ++i;
        }
        return true;
    }

    static int SDBBinarySearch(SDBInfo hsdb, Record value, Record record, int first, int last, Int insertPos, int compareMethod) {
        int mid = 0;
        while (first <= last) {
            mid = first + (last - first) / 2;
            hsdb.getAt(mid, record);
            int res = value.compare(record, compareMethod);
            if (res == 0) {
                insertPos.i = mid;
                return mid;
            }
            if (res < 0) {
                last = mid - 1;
                continue;
            }
            first = mid + 1;
        }
        insertPos.i = first;
        return -1;
    }
}

