/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.Int;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Str {
    String s;

    Str(String str) {
        this.s = str;
    }

    Str() {
        this.s = new String();
    }

    static int indexOfNoCase(String haystack, String needle) {
        String haystackLower = haystack.toLowerCase();
        String needleLower = needle.toLowerCase();
        return haystackLower.indexOf(needleLower);
    }

    static int indexOfMatchWholeWordOnly(String haystack, String needle, int startPos) {
        int pos = haystack.indexOf(needle, startPos);
        if (pos != -1 && (pos > 0 && Character.isLetter(haystack.charAt(pos - 1)) || pos + needle.length() < haystack.length() && Character.isLetter(haystack.charAt(pos + needle.length())))) {
            return Str.indexOfMatchWholeWordOnly(haystack, needle, pos + needle.length());
        }
        return pos;
    }

    static String replaceNoCase(String src, String trg, String string, boolean bWholeWordOnly) {
        int pos = 0;
        String retstr = new String();
        String stringLower = string.toLowerCase();
        String srcLower = src.toLowerCase();
        while (true) {
            int newpos;
            int n = newpos = bWholeWordOnly ? Str.indexOfMatchWholeWordOnly(stringLower, srcLower, pos) : stringLower.indexOf(srcLower, pos);
            if (newpos == -1) break;
            if (newpos - pos > 0) {
                retstr = String.valueOf(retstr) + string.substring(pos, newpos);
            }
            retstr = String.valueOf(retstr) + trg;
            pos = newpos + src.length();
        }
        retstr = String.valueOf(retstr) + string.substring(pos);
        return retstr;
    }

    static String getUTF8Value(char c) {
        String retval = new String();
        if (c < '\u0080') {
            retval = String.valueOf(retval) + c;
        } else {
            char c1 = (char)(192 + c / 64);
            char c2 = (char)(128 + c % 64);
            retval = String.valueOf(retval) + c1;
            retval = String.valueOf(retval) + c2;
        }
        return retval;
    }

    static String getUTF8Value(String s) {
        String retval = new String();
        int len = s.length();
        int i = 0;
        while (i < len) {
            retval = String.valueOf(retval) + Str.getUTF8Value(s.charAt(i));
            ++i;
        }
        return retval;
    }

    static String replaceAll(String src, String trg, String string) {
        int newpos;
        int pos = 0;
        String retstr = new String();
        while ((newpos = string.indexOf(src, pos)) != -1) {
            if (newpos - pos > 0) {
                retstr = String.valueOf(retstr) + string.substring(pos, newpos);
            }
            retstr = String.valueOf(retstr) + trg;
            pos = newpos + src.length();
        }
        retstr = String.valueOf(retstr) + string.substring(pos);
        return retstr;
    }

    private static boolean isAnsiString(String word) {
        int len = word.length();
        int i = 0;
        while (i < len) {
            if (word.charAt(i) >= '\u0080') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static String fixWordCase(int wordCase, String word) {
        String result = new String();
        if (word.length() > 0) {
            result = wordCase == 2 && word.charAt(0) < '\u0080' ? String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1) : (wordCase == 1 && Str.isAnsiString(word) ? word.toUpperCase() : word);
        }
        return result;
    }

    static boolean findStringInList(String str, String list, String sep) {
        String[] chunks = list.split(sep);
        int i = 0;
        while (i < chunks.length) {
            int foundPos = Str.indexOfNoCase(str, chunks[i]);
            if (foundPos == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean hasStringWildcards(String str) {
        return str.indexOf("*") != -1 || str.indexOf("?") != -1;
    }

    static boolean compareStringWithWildcardString(String str, String wildcardStr) {
        String pattern = wildcardStr;
        try {
            pattern = Str.replaceAll(".", "\\.", pattern);
            pattern = pattern.replace('?', '.');
            pattern = Str.replaceAll("*", ".*", pattern);
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(str);
            return m.matches();
        }
        catch (Exception e) {
            System.err.println("Could not compare " + str + " with " + pattern);
            return false;
        }
    }

    static int getUnicodeValue(String str, int startPos, Int charLength) {
        char ch0 = str.charAt(startPos);
        if (ch0 < '\u0080') {
            charLength.i = 1;
            return ch0;
        }
        if (ch0 > '\u00bf' && ch0 < '\u00e0') {
            if (startPos + 1 >= str.length()) {
                charLength.i = 1;
                return 0;
            }
            charLength.i = 2;
            char ch1 = str.charAt(startPos + 1);
            return (ch0 & 0x1F) << 6 | ch1 & 0x3F;
        }
        if (startPos + 2 >= str.length()) {
            charLength.i = 1;
            return 0;
        }
        charLength.i = 3;
        char ch1 = str.charAt(startPos + 1);
        char ch2 = str.charAt(startPos + 2);
        return (ch0 & 0xF) << 12 | (ch1 & 0x3F) << 6 | ch2 & 0x3F;
    }
}

