/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.AdvSearchNode;
import com.xtreeme.search.Bitfield24_8_8Record;
import com.xtreeme.search.General;
import com.xtreeme.search.IndexPosInfo;
import com.xtreeme.search.Int;
import com.xtreeme.search.KeywordInfo;
import com.xtreeme.search.NodeResults;
import com.xtreeme.search.ResultSortByDateComparator;
import com.xtreeme.search.ResultSortByScoreComparator;
import com.xtreeme.search.ResultSortBySizeComparator;
import com.xtreeme.search.ResultSortByTypeComparator;
import com.xtreeme.search.ResultSortByURLNameComparator;
import com.xtreeme.search.SearchEngineBase;
import com.xtreeme.search.SearchFilter;
import com.xtreeme.search.SearchInfo;
import com.xtreeme.search.SingleExpressionInfo;
import com.xtreeme.search.SingleResult;
import com.xtreeme.search.Str;
import com.xtreeme.search.TokenInfo;
import com.xtreeme.search.URLIndexRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class AdvSearchEngine
extends SearchEngineBase {
    private static final String STR_BEFORE_OPERATOR = "JUST_BEFORE";
    private static final String STR_AND_OPERATOR = "AND";
    private static final String STR_OR_OPERATOR = "OR";
    private static final String STR_NOT_OPERATOR = "NOT";
    private static final String STR_AND_OPERATOR_INTERNAL = "OP_AND";
    private static final String STR_OR_OPERATOR_INTERNAL = "OP_OR";
    private static final String STR_NOT_OPERATOR_INTERNAL = "OP_NOT";
    private static final int SCORE_UNKNOWN = 1;
    private static final int SCORE_OR_BOTH_FOUND_MULT = 2;
    private static final int SCORE_OR_BOTH_FOUND_FIXED = 5;
    private static final int WILDCARD_KEYWORD_MAX_COUNT = 1000;
    private static final int MAX_HIGHLIGHTED_WILDCARD_KEYWORDS = 20;
    static final int SORT_SCORE = 0;
    static final int SORT_URL = 1;
    static final int SORT_TYPE = 2;
    static final int SORT_SIZE = 3;
    static final int SORT_DATE = 4;
    static final int SORT_REVERSE = 10;

    public AdvSearchEngine(SearchInfo searchInfo, int minLength, int maxResults, String prefix, SearchFilter filter) {
        super(searchInfo, minLength, maxResults, prefix, filter);
    }

    private int getOperatorTokenValue(String string, boolean bAcceptOperators, boolean bCheckOriginalOperatorStrings) {
        if (string.compareToIgnoreCase(STR_BEFORE_OPERATOR) == 0) {
            return 65539;
        }
        if (bAcceptOperators && string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_AND_OPERATOR : STR_AND_OPERATOR_INTERNAL) == 0) {
            return 65537;
        }
        if (bAcceptOperators && string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_OR_OPERATOR : STR_OR_OPERATOR_INTERNAL) == 0) {
            return 65538;
        }
        if (bAcceptOperators && string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_NOT_OPERATOR : STR_NOT_OPERATOR_INTERNAL) == 0) {
            return 65540;
        }
        return 0;
    }

    String getOperatorString(int operatorType, boolean bUseOriginalOperatorStrings) {
        switch (operatorType) {
            case 65537: {
                return bUseOriginalOperatorStrings ? STR_AND_OPERATOR : STR_AND_OPERATOR_INTERNAL;
            }
            case 65538: {
                return bUseOriginalOperatorStrings ? STR_OR_OPERATOR : STR_OR_OPERATOR_INTERNAL;
            }
            case 65540: {
                return bUseOriginalOperatorStrings ? STR_NOT_OPERATOR : STR_NOT_OPERATOR_INTERNAL;
            }
            case 65539: {
                return STR_BEFORE_OPERATOR;
            }
        }
        return null;
    }

    private int checkOperatorKeyword(String inputStr, int pos) {
        int len = inputStr.length();
        int i = pos;
        while (i < len) {
            char ch = inputStr.charAt(i);
            if (ch == '\u0000' || SearchEngineBase.isTerminatingCharacter(ch, 65001)) break;
            ++i;
        }
        return this.getOperatorTokenValue(inputStr.substring(pos, i), true, true);
    }

    /*
     * Unable to fully structure code
     */
    private boolean searchParseQueryStringAdv(String inputStr, char[] specialCharacters, Str outputStr) {
        bInsideQuote = false;
        bPrevCharSeparator = true;
        res = new String();
        len = inputStr.length();
        i = 0;
        while (i < len && i < 5120) {
            block7: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        ch = inputStr.charAt(i);
                                        if (ch != '\"') break block6;
                                        res = bInsideQuote == false ? String.valueOf(res) + " ( " : String.valueOf(res) + " ) ";
                                        bInsideQuote = bInsideQuote == false;
                                        bPrevCharSeparator = true;
                                        break block7;
                                    }
                                    if (ch != '(' && ch != '[') break block8;
                                    res = String.valueOf(res) + " ( ";
                                    bPrevCharSeparator = true;
                                    break block7;
                                }
                                if (ch != ')' && ch != ']') break block9;
                                res = String.valueOf(res) + " ) ";
                                bPrevCharSeparator = true;
                                break block7;
                            }
                            if (ch != '{' && ch != '}') break block10;
                            res = String.valueOf(res) + ch;
                            if (ch == '}') {
                                res = String.valueOf(res) + ' ';
                            }
                            bPrevCharSeparator = true;
                            break block7;
                        }
                        if (ch != '*' && ch != '?') break block11;
                        res = String.valueOf(res) + ch;
                        bPrevCharSeparator = false;
                        break block7;
                    }
                    if (!SearchEngineBase.isTerminatingCharacter(ch, 65001)) break block12;
                    res = bInsideQuote != false ? String.valueOf(res) + " JUST_BEFORE " : String.valueOf(res) + ' ';
                    bPrevCharSeparator = true;
                    break block7;
                }
                if (!bPrevCharSeparator || bInsideQuote || (operatorKeyword = this.checkOperatorKeyword(inputStr, i)) == 0) ** GOTO lbl-1000
                origOperator = this.getOperatorString(operatorKeyword, true);
                intOperator = this.getOperatorString(operatorKeyword, false);
                if (origOperator != null && intOperator != null) {
                    res = String.valueOf(res) + intOperator;
                    i += origOperator.length() - 1;
                    bPrevCharSeparator = false;
                } else lbl-1000:
                // 2 sources

                {
                    if (!SearchEngineBase.checkSpecialCharacter(inputStr, i, specialCharacters, spRes = new Str(), srcChars = new Int())) {
                        res = String.valueOf(res) + ch;
                    } else {
                        res = String.valueOf(res) + spRes.s;
                        i += srcChars.i - 1;
                    }
                    bPrevCharSeparator = false;
                }
            }
            ++i;
        }
        outputStr.s = res;
        return true;
    }

    private boolean isFilterToken(String string, Int filterValue) {
        if (string.length() > 3 && string.charAt(0) == '{') {
            if (string.charAt(1) == 'Q' && string.charAt(2) == 'F') {
                filterValue.i = General.stringToInt(string.substring(3, string.length() - 1));
                return true;
            }
            if (string.compareToIgnoreCase("{OPOR}") == 0) {
                this.searchFilter.bDefaultAnd = false;
                return true;
            }
        }
        return false;
    }

    private int getTokenTypeFromString(String string) {
        if (string.compareToIgnoreCase(STR_BEFORE_OPERATOR) == 0 || string.compareToIgnoreCase(STR_AND_OPERATOR_INTERNAL) == 0 || string.compareToIgnoreCase(STR_OR_OPERATOR_INTERNAL) == 0) {
            return 3;
        }
        if (string.compareToIgnoreCase(STR_NOT_OPERATOR_INTERNAL) == 0) {
            return 2;
        }
        if (string.compareToIgnoreCase("(") == 0) {
            return 0;
        }
        if (string.compareToIgnoreCase(")") == 0) {
            return 1;
        }
        return 4;
    }

    private int getOperatorTokenValue(String string, boolean bCheckOriginalOperatorStrings) {
        if (string.compareToIgnoreCase(STR_BEFORE_OPERATOR) == 0) {
            return 65539;
        }
        if (string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_AND_OPERATOR : STR_AND_OPERATOR_INTERNAL) == 0) {
            return 65537;
        }
        if (string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_OR_OPERATOR : STR_OR_OPERATOR_INTERNAL) == 0) {
            return 65538;
        }
        if (string.compareToIgnoreCase(bCheckOriginalOperatorStrings ? STR_NOT_OPERATOR : STR_NOT_OPERATOR_INTERNAL) == 0) {
            return 65540;
        }
        return 0;
    }

    private boolean insertTokenIntoList(int tokenType, int tokenValue, int locationFilter, List tokenList) {
        TokenInfo newToken = new TokenInfo();
        newToken.tokenType = tokenType;
        newToken.tokenValue = tokenValue;
        newToken.locationFilter = locationFilter;
        tokenList.add(newToken);
        return true;
    }

    private boolean insertWildcardKeywordsIntoList(String wildcardStr, int minKeywordLength, int maxKeywordCount, int locationFilter, List tokenList, List keywordList) {
        ArrayList wildcardKeywords = new ArrayList();
        boolean bFirstKeyword = true;
        int counter = 0;
        if (!this.insertTokenIntoList(0, 0, locationFilter, tokenList)) {
            return false;
        }
        if (this.si.getKeywordsFromWildcardString(wildcardStr, minKeywordLength, maxKeywordCount, wildcardKeywords)) {
            ListIterator it = wildcardKeywords.listIterator();
            while (it.hasNext()) {
                Int keywordIDObj = (Int)it.next();
                int keywordID = keywordIDObj.i;
                if (!bFirstKeyword && !this.insertTokenIntoList(3, 65538, locationFilter, tokenList)) {
                    return false;
                }
                KeywordInfo keywordItem = new KeywordInfo();
                if (counter < 20) {
                    keywordItem.ID = keywordID;
                    keywordItem.expressionId = 0;
                    keywordItem.currentFilePos = -1;
                    Str strVal = new Str();
                    if (!SearchInfo.searchFindStringNameFromId(this.si.keywordIndex2DB, this.si.keywordDB, keywordID, strVal, true)) {
                        keywordItem.keyword = strVal.s;
                    }
                    keywordList.add(keywordItem);
                }
                if (!this.insertTokenIntoList(4, keywordID, locationFilter, tokenList)) {
                    return false;
                }
                bFirstKeyword = false;
                ++counter;
            }
        }
        return this.insertTokenIntoList(1, 0, locationFilter, tokenList);
    }

    private boolean searchTokenizeQueryAdv(List keywordList, String queryStr, int minKeywordLength, List tokenList) {
        String currentToken = new String();
        int locationFilter = 0;
        boolean bContinuedExpression = false;
        int nextExpressionId = 1;
        int len = queryStr.length();
        int i = 0;
        while (i <= len) {
            char ch;
            char c = ch = i == len ? (char)' ' : (char)queryStr.charAt(i);
            if (ch == ' ') {
                if (currentToken.length() != 0) {
                    Int filter = new Int();
                    if (this.isFilterToken(currentToken, filter)) {
                        locationFilter = filter.i;
                    } else {
                        TokenInfo newToken = new TokenInfo();
                        boolean bInsertToken = true;
                        newToken.tokenType = this.getTokenTypeFromString(currentToken);
                        newToken.locationFilter = locationFilter;
                        if (newToken.tokenType == 2 || newToken.tokenType == 3) {
                            newToken.tokenValue = this.getOperatorTokenValue(currentToken, false);
                            bContinuedExpression = newToken.tokenValue == 65539;
                        } else if (newToken.tokenType == 4) {
                            if (Str.hasStringWildcards(currentToken)) {
                                if (!this.insertWildcardKeywordsIntoList(currentToken, minKeywordLength, 1000, locationFilter, tokenList, keywordList)) {
                                    return false;
                                }
                                bInsertToken = false;
                                bContinuedExpression = false;
                            } else {
                                int keywordID = this.si.getKeywordIdFromString(currentToken);
                                KeywordInfo keywordItem = new KeywordInfo();
                                keywordItem.ID = keywordID;
                                if (!bContinuedExpression) {
                                    keywordItem.expressionId = 0;
                                } else {
                                    int prevStatusValue = 1;
                                    ListIterator tailIt = keywordList.listIterator();
                                    while (tailIt.hasNext()) {
                                        tailIt.next();
                                    }
                                    if (tailIt.hasPrevious()) {
                                        KeywordInfo tailInfo = (KeywordInfo)tailIt.previous();
                                        if (tailInfo.expressionPos == 0) {
                                            tailInfo.expressionPos = 1;
                                            tailInfo.expressionId = ++nextExpressionId;
                                            tailInfo.bExpressionEnd = false;
                                        } else if (keywordID != 0) {
                                            tailInfo.bExpressionEnd = false;
                                        }
                                        prevStatusValue = tailInfo.expressionPos;
                                    }
                                    keywordItem.expressionPos = prevStatusValue + 1;
                                    keywordItem.expressionId = nextExpressionId;
                                    keywordItem.bExpressionEnd = true;
                                }
                                keywordItem.currentFilePos = -1;
                                Str keywordBuffer = new Str();
                                SearchInfo.searchFindStringNameFromId(this.si.keywordIndex2DB, this.si.keywordDB, keywordID, keywordBuffer, true);
                                keywordItem.keyword = keywordBuffer.s;
                                keywordList.add(keywordItem);
                                bContinuedExpression = false;
                                if (currentToken.length() < minKeywordLength) {
                                    bInsertToken = false;
                                }
                                newToken.tokenValue = keywordID;
                            }
                        } else {
                            newToken.tokenValue = 0;
                            bContinuedExpression = false;
                        }
                        if (bInsertToken) {
                            tokenList.add(newToken);
                        }
                    }
                    currentToken = "";
                }
            } else {
                currentToken = String.valueOf(currentToken) + ch;
            }
            ++i;
        }
        return true;
    }

    private AdvSearchNode buildSetTree(ListIterator firstTokenItem) {
        AdvSearchNode parentNode = new AdvSearchNode();
        boolean bNegativeValue = false;
        int defaultOperator = 65537;
        if (this.searchFilter != null && !this.searchFilter.bDefaultAnd) {
            defaultOperator = 65538;
        }
        ListIterator currentTokenItem = firstTokenItem;
        while (currentTokenItem.hasNext()) {
            TokenInfo currentToken = (TokenInfo)currentTokenItem.next();
            if (currentToken == null) continue;
            switch (currentToken.tokenType) {
                case 0: {
                    AdvSearchNode newNode = this.buildSetTree(currentTokenItem);
                    newNode.bComplement = bNegativeValue;
                    if (parentNode.leftNode == null) {
                        parentNode.leftNode = newNode;
                        break;
                    }
                    if (parentNode.rightNode == null) {
                        if (parentNode.operatorType == 0) {
                            parentNode.operatorType = defaultOperator;
                        }
                        parentNode.rightNode = newNode;
                        break;
                    }
                    AdvSearchNode newNode2 = new AdvSearchNode();
                    newNode2.leftNode = parentNode;
                    newNode2.rightNode = newNode;
                    newNode2.operatorType = defaultOperator;
                    parentNode = newNode2;
                    break;
                }
                case 1: {
                    return parentNode;
                }
                case 3: {
                    AdvSearchNode newNode;
                    if (parentNode.operatorType != 0) {
                        newNode = new AdvSearchNode();
                        newNode.leftNode = parentNode;
                        parentNode = newNode;
                    }
                    parentNode.operatorType = currentToken.tokenValue;
                    parentNode.locationFilter = currentToken.locationFilter;
                    break;
                }
                case 4: {
                    if (parentNode.leftNode == null) {
                        parentNode.leftNode = new AdvSearchNode();
                        parentNode.leftNode.createNewKeywordNode(currentToken.tokenValue, currentToken.locationFilter, bNegativeValue);
                        break;
                    }
                    if (parentNode.rightNode == null) {
                        if (parentNode.operatorType == 0) {
                            parentNode.operatorType = defaultOperator;
                        }
                        parentNode.rightNode = new AdvSearchNode();
                        parentNode.rightNode.createNewKeywordNode(currentToken.tokenValue, currentToken.locationFilter, bNegativeValue);
                        break;
                    }
                    AdvSearchNode newNode2 = new AdvSearchNode();
                    newNode2.leftNode = parentNode;
                    newNode2.rightNode = new AdvSearchNode();
                    newNode2.rightNode.createNewKeywordNode(currentToken.tokenValue, currentToken.locationFilter, bNegativeValue);
                    newNode2.operatorType = defaultOperator;
                    parentNode = newNode2;
                }
            }
            bNegativeValue = currentToken.tokenType == 2;
        }
        return parentNode;
    }

    private NodeResults fillAllURLs() {
        int count = this.si.URLIndexDB.getSize();
        if (count > 0) {
            NodeResults results = new NodeResults();
            results.bComplement = false;
            results.URLCount = count;
            int currentResult = 0;
            while (currentResult < count) {
                URLIndexRecord URLRecord = new URLIndexRecord();
                if (!this.si.URLIndexDB.getAt(currentResult, URLRecord)) {
                    return null;
                }
                SingleResult res = new SingleResult();
                res.URLID = URLRecord.data24;
                res.score = 1;
                results.URLIDs.add(res);
                ++currentResult;
            }
            return results;
        }
        return null;
    }

    private NodeResults fillResults(int keywordID, int locationFilter) {
        int count;
        NodeResults results = new NodeResults();
        results.bComplement = false;
        results.URLCount = 0;
        IndexPosInfo indexPosInfo = new IndexPosInfo();
        boolean bSearchRecord = SearchInfo.searchFindPosIn24_32Index(this.si.searchByKeywordIndexDB, keywordID, indexPosInfo);
        int dbSize = this.si.searchByKeywordDB.getSize();
        if (bSearchRecord && (count = indexPosInfo.endPos == -1 ? dbSize - indexPosInfo.startPos : indexPosInfo.endPos - indexPosInfo.startPos) > 0) {
            results.bComplement = false;
            results.URLCount = 0;
            int currentFilePos = indexPosInfo.startPos;
            int currentResult = 0;
            while (currentResult < count) {
                Bitfield24_8_8Record searchRecord = new Bitfield24_8_8Record();
                if (!this.si.searchByKeywordDB.getAt(currentFilePos, searchRecord)) {
                    return null;
                }
                if (locationFilter == 0 || (locationFilter & searchRecord.data8_2) != 0) {
                    SingleResult res = new SingleResult();
                    res.URLID = searchRecord.data24;
                    res.score = searchRecord.data8_1;
                    results.URLIDs.add(res);
                    ++results.URLCount;
                    ++currentResult;
                } else {
                    --count;
                }
                ++currentFilePos;
            }
        }
        return results;
    }

    private boolean advSearchCheckSingleExpression(int URLID, List expressionList) {
        IndexPosInfo urlInfo;
        if (!(this.si.positionsByURLDB.isInitialized() && this.si.positionsByURLIndex1DB.isInitialized() && this.si.positionsByURLIndex2DB.isInitialized())) {
            return true;
        }
        if (expressionList.size() > 0 && SearchInfo.searchFindPosIn24_32Index(this.si.positionsByURLIndex1DB, URLID, urlInfo = new IndexPosInfo())) {
            if (urlInfo.endPos == -1) {
                urlInfo.endPos = this.si.positionsByURLIndex2DB.getSize();
            }
            ListIterator expressionIterator = expressionList.listIterator();
            int nKeyword = 0;
            while (expressionIterator.hasNext()) {
                SingleExpressionInfo expressionInfo = (SingleExpressionInfo)expressionIterator.next();
                Int dummy = new Int();
                if (SearchInfo.searchFindPosIn24_32IndexEx(this.si.positionsByURLIndex2DB, expressionInfo.keywordInfo, expressionInfo.keywordID, urlInfo.startPos, urlInfo.endPos - 1, dummy)) {
                    if (expressionInfo.keywordInfo.endPos == -1) {
                        expressionInfo.keywordInfo.endPos = this.si.positionsByURLDB.getSize();
                    }
                    expressionInfo.currentPos = expressionInfo.keywordInfo.startPos;
                    if (!this.si.positionsByURLDB.getAt(expressionInfo.currentPos, expressionInfo.rec)) {
                        return false;
                    }
                    expressionInfo.currentValue = expressionInfo.rec.getValue() + expressionList.size() - nKeyword - 1;
                }
                ++nKeyword;
            }
            while (true) {
                expressionIterator = expressionList.listIterator();
                nKeyword = 0;
                int searchedPos = -1;
                int minPos = -1;
                SingleExpressionInfo minPosInfo = null;
                int minPosIndex = -1;
                while (expressionIterator.hasNext()) {
                    SingleExpressionInfo expressionInfo = (SingleExpressionInfo)expressionIterator.next();
                    if (expressionInfo.currentPos >= expressionInfo.keywordInfo.endPos) {
                        return false;
                    }
                    if (nKeyword == 0) {
                        searchedPos = expressionInfo.currentValue;
                    } else if (searchedPos != expressionInfo.currentValue) {
                        searchedPos = -1;
                    }
                    if (minPos == -1 || expressionInfo.currentValue < minPos) {
                        minPos = expressionInfo.currentValue;
                        minPosInfo = expressionInfo;
                        minPosIndex = nKeyword;
                    }
                    ++nKeyword;
                }
                if (searchedPos != -1) {
                    return true;
                }
                if (minPosInfo == null) continue;
                ++minPosInfo.currentPos;
                if (minPosInfo.currentPos == minPosInfo.keywordInfo.endPos) {
                    return false;
                }
                if (!this.si.positionsByURLDB.getAt(minPosInfo.currentPos, minPosInfo.rec)) {
                    return false;
                }
                minPosInfo.currentValue = minPosInfo.rec.getValue() + expressionList.size() - minPosIndex - 1;
            }
        }
        return false;
    }

    private NodeResults mergeResultsAnd(NodeResults leftResults, NodeResults rightResults, boolean bRightResultsComplemented, boolean bCheckBeforeCondition, AdvSearchNode node) {
        if (leftResults != null && rightResults != null) {
            NodeResults results = new NodeResults();
            results.URLCount = 0;
            results.bComplement = false;
            if ((leftResults.URLCount == 0 || rightResults.URLCount == 0) && !bRightResultsComplemented || leftResults.URLCount == 0 && bRightResultsComplemented) {
                results.URLCount = 0;
            } else {
                NodeResults secondResults;
                NodeResults firstResults;
                if (leftResults.URLCount < rightResults.URLCount || bRightResultsComplemented) {
                    firstResults = leftResults;
                    secondResults = rightResults;
                } else {
                    firstResults = rightResults;
                    secondResults = leftResults;
                }
                int first = 0;
                int last = secondResults.URLCount - 1;
                int i = 0;
                while (i < firstResults.URLCount) {
                    int result;
                    SingleResult firstRes = (SingleResult)firstResults.URLIDs.get(i);
                    int currentValue = firstRes.URLID;
                    Int insertPos = new Int();
                    if (last != -1) {
                        int revSearchResult = secondResults.numericArrayReverseBinarySearchAdv(currentValue, first, last);
                        if (revSearchResult > last) {
                            revSearchResult = last;
                        }
                        result = secondResults.numericArrayBinarySearchAdv(currentValue, first, revSearchResult, insertPos);
                    } else {
                        result = -1;
                        insertPos.i = 0;
                    }
                    if ((result != -1 && !bRightResultsComplemented || result == -1 && bRightResultsComplemented) && (node == null || node.operatorType != 65539 || !bCheckBeforeCondition || this.advSearchCheckSingleExpression(currentValue, node.expressionList))) {
                        SingleResult res = new SingleResult();
                        res.URLID = currentValue;
                        res.score = firstRes.score + (result == -1 ? 0 : ((SingleResult)secondResults.URLIDs.get((int)result)).score);
                        results.URLIDs.add(res);
                        ++results.URLCount;
                    }
                    first = insertPos.i;
                    ++i;
                }
            }
            return results;
        }
        return null;
    }

    private NodeResults mergeResultsOr(NodeResults leftResults, NodeResults rightResults) {
        if (leftResults != null && rightResults != null) {
            NodeResults results = new NodeResults();
            results.URLCount = 0;
            results.bComplement = false;
            if (leftResults.URLCount != 0 || rightResults.URLCount != 0) {
                SingleResult res;
                int currentLeftPos = 0;
                int currentRightPos = 0;
                while (currentLeftPos < leftResults.URLCount && currentRightPos < rightResults.URLCount) {
                    SingleResult res2;
                    SingleResult leftRes = (SingleResult)leftResults.URLIDs.get(currentLeftPos);
                    SingleResult rightRes = (SingleResult)rightResults.URLIDs.get(currentRightPos);
                    int dif = rightRes.URLID - leftRes.URLID;
                    if (dif == 0) {
                        res2 = new SingleResult();
                        res2.URLID = leftRes.URLID;
                        res2.score = (leftRes.score + rightRes.score) * 2 + 5;
                        results.URLIDs.add(res2);
                        ++currentLeftPos;
                        ++currentRightPos;
                    } else if (dif < 0) {
                        res2 = (SingleResult)rightResults.URLIDs.get(currentRightPos);
                        results.URLIDs.add(res2);
                        ++currentRightPos;
                    } else {
                        res2 = (SingleResult)leftResults.URLIDs.get(currentLeftPos);
                        results.URLIDs.add(res2);
                        ++currentLeftPos;
                    }
                    ++results.URLCount;
                }
                while (currentLeftPos < leftResults.URLCount) {
                    res = (SingleResult)leftResults.URLIDs.get(currentLeftPos);
                    results.URLIDs.add(res);
                    ++results.URLCount;
                    ++currentLeftPos;
                }
                while (currentRightPos < rightResults.URLCount) {
                    res = (SingleResult)rightResults.URLIDs.get(currentRightPos);
                    results.URLIDs.add(res);
                    ++results.URLCount;
                    ++currentRightPos;
                }
            }
            return results;
        }
        return null;
    }

    private NodeResults mergeResults(NodeResults leftResults, NodeResults rightResults, AdvSearchNode node, boolean bCheckBeforeCondition) {
        int operatorType = node.operatorType;
        if (leftResults != null && rightResults != null) {
            if (operatorType == 65537 || operatorType == 65539) {
                if (leftResults.bComplement && rightResults.bComplement) {
                    NodeResults results = this.mergeResultsOr(leftResults, rightResults);
                    if (results != null) {
                        results.bComplement = true;
                    }
                    return results;
                }
                if (leftResults.bComplement && !rightResults.bComplement) {
                    return this.mergeResultsAnd(rightResults, leftResults, true, bCheckBeforeCondition, node);
                }
                if (!leftResults.bComplement && rightResults.bComplement) {
                    return this.mergeResultsAnd(leftResults, rightResults, true, bCheckBeforeCondition, node);
                }
                return this.mergeResultsAnd(leftResults, rightResults, false, bCheckBeforeCondition, node);
            }
            if (operatorType == 65538) {
                if (leftResults.bComplement && rightResults.bComplement) {
                    NodeResults results = this.mergeResultsAnd(leftResults, rightResults, false, bCheckBeforeCondition, node);
                    if (results != null) {
                        results.bComplement = true;
                    }
                    return results;
                }
                if (leftResults.bComplement && !rightResults.bComplement) {
                    NodeResults results = this.mergeResultsAnd(leftResults, rightResults, true, bCheckBeforeCondition, node);
                    if (results != null) {
                        results.bComplement = true;
                    }
                    return results;
                }
                if (!leftResults.bComplement && rightResults.bComplement) {
                    NodeResults results = this.mergeResultsAnd(rightResults, leftResults, true, bCheckBeforeCondition, node);
                    if (results != null) {
                        results.bComplement = true;
                    }
                    return results;
                }
                return this.mergeResultsOr(leftResults, rightResults);
            }
        }
        return null;
    }

    private void addNodeKeywordsToExpressionList(AdvSearchNode node, List list) {
        if (node.expressionList != null) {
            ListIterator iterator = node.expressionList.listIterator();
            while (iterator.hasNext()) {
                SingleExpressionInfo info = (SingleExpressionInfo)iterator.next();
                SingleExpressionInfo newInfo = new SingleExpressionInfo();
                newInfo.keywordID = info.keywordID;
                list.add(newInfo);
            }
        } else if (node.nodeValue != 0 && node.operatorType == 0) {
            SingleExpressionInfo newInfo = new SingleExpressionInfo();
            newInfo.keywordID = node.nodeValue;
            list.add(newInfo);
        }
    }

    private ArrayList createExpressionList(AdvSearchNode node) {
        if (node != null && node.leftNode != null && node.rightNode != null && node.operatorType == 65539) {
            ArrayList list = new ArrayList();
            this.addNodeKeywordsToExpressionList(node.leftNode, list);
            this.addNodeKeywordsToExpressionList(node.rightNode, list);
            return list;
        }
        return null;
    }

    private NodeResults getNodeURLs(AdvSearchNode node, boolean bCheckBeforeCondition) {
        NodeResults results = null;
        if (node != null) {
            NodeResults leftResults = this.getNodeURLs(node.leftNode, node.operatorType != 65539);
            NodeResults rightResults = this.getNodeURLs(node.rightNode, node.operatorType != 65539);
            node.expressionList = this.createExpressionList(node);
            if (leftResults != null && rightResults != null) {
                results = this.mergeResults(leftResults, rightResults, node, bCheckBeforeCondition);
                if (node.bComplement) {
                    results.bComplement = !results.bComplement;
                }
            } else if (leftResults != null) {
                results = leftResults;
                if (node.bComplement) {
                    results.bComplement = !results.bComplement;
                }
            } else if (rightResults != null) {
                results = rightResults;
                if (node.bComplement) {
                    results.bComplement = !results.bComplement;
                }
            } else if (node.operatorType == 0) {
                results = this.fillResults(node.nodeValue, node.locationFilter);
                if (results != null) {
                    results.bComplement = node.bComplement;
                }
            } else {
                results = null;
            }
        }
        return results;
    }

    private NodeResults getComplement(NodeResults inResults) {
        NodeResults allResults = this.fillAllURLs();
        return this.mergeResultsAnd(allResults, inResults, true, false, null);
    }

    private boolean findResults(List tokenList, AdvSearchNode root, int sortType, List resultList) {
        NodeResults finalResults = null;
        NodeResults tempResults = this.getNodeURLs(root, true);
        if (tempResults != null) {
            finalResults = tempResults.bComplement ? this.getComplement(tempResults) : tempResults;
        }
        if (finalResults != null) {
            int currentResult = 0;
            while (currentResult < finalResults.URLCount) {
                SingleResult res = (SingleResult)finalResults.URLIDs.get(currentResult);
                SearchEngineBase.searchAddResult(this.si, res.URLID, res.score, sortType, this.searchFilter, resultList);
                if (resultList.size() >= this.maxResults) break;
                ++currentResult;
            }
        }
        return true;
    }

    void replaceEscapeSequences(String keywordStr, Str outputStr, int codepage) {
        if (codepage == 65001) {
            outputStr.s = keywordStr;
        } else {
            int i = 0;
            while (i < keywordStr.length()) {
                char ch = keywordStr.charAt(i);
                outputStr.s = ch >= '\u0080' ? String.valueOf(outputStr.s) + Str.getUTF8Value(ch) : String.valueOf(outputStr.s) + ch;
                ++i;
            }
        }
    }

    public boolean searchStart(String keywords, int sortType, char[] specialChars, ArrayList resultList, ArrayList keywordList, int codepage) {
        AdvSearchNode root;
        Str outputStr = new Str();
        ArrayList tokenList = new ArrayList();
        Str queryStr = new Str();
        this.replaceEscapeSequences(keywords, queryStr, codepage);
        if (this.searchParseQueryStringAdv(queryStr.s, specialChars, outputStr) && this.searchTokenizeQueryAdv(keywordList, outputStr.s, this.minKeywordLength, tokenList) && (root = this.buildSetTree(tokenList.listIterator())) != null && this.findResults(tokenList, root, sortType, resultList) && resultList.size() > 1) {
            Comparator comparator;
            switch (sortType) {
                case 1: {
                    comparator = new ResultSortByURLNameComparator(false);
                    break;
                }
                case 2: {
                    comparator = new ResultSortByTypeComparator(false);
                    break;
                }
                case 3: {
                    comparator = new ResultSortBySizeComparator(false);
                    break;
                }
                case 4: {
                    comparator = new ResultSortByDateComparator(false);
                    break;
                }
                case 11: {
                    comparator = new ResultSortByURLNameComparator(true);
                    break;
                }
                case 12: {
                    comparator = new ResultSortByTypeComparator(true);
                    break;
                }
                case 13: {
                    comparator = new ResultSortBySizeComparator(true);
                    break;
                }
                case 14: {
                    comparator = new ResultSortByDateComparator(true);
                    break;
                }
                case 10: {
                    comparator = new ResultSortByScoreComparator(true);
                    break;
                }
                default: {
                    comparator = new ResultSortByScoreComparator(false);
                }
            }
            Collections.sort(resultList, comparator);
        }
        return true;
    }
}

