/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.General;
import com.xtreeme.search.SearchFilter;
import com.xtreeme.search.SearchParams;
import com.xtreeme.search.SearchSettings;
import com.xtreeme.search.Str;
import java.net.URLDecoder;

public abstract class ParameterReader {
    SearchSettings searchSettings;
    SearchFilter searchFilter = new SearchFilter();
    SearchParams params = new SearchParams();

    abstract String getParameter(String var1);

    abstract boolean getParameterFromIndex(int var1, Str var2, Str var3);

    abstract int getParameterCount();

    void readParameters(String basePath) {
        String pagePath = this.getParameter("wrap");
        if (pagePath == null) {
            pagePath = new String();
        }
        String prefix = this.getParameter("pref");
        String query = this.getParameter("q");
        boolean bPhraseMode = false;
        if (query == null || query.length() == 0) {
            query = this.getParameter("qor");
            if (query != null && query.length() > 0) {
                this.searchFilter.bDefaultAnd = false;
            } else {
                query = this.getParameter("qph");
                if (query != null && query.length() > 0) {
                    bPhraseMode = true;
                }
            }
        }
        if (query == null) {
            query = "";
        }
        String urlGroup = this.getParameter("sec");
        try {
            if (urlGroup != null && urlGroup.length() > 0) {
                urlGroup = URLDecoder.decode(urlGroup, "UTF-8");
            }
            this.searchFilter.setURLGroup(urlGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String defaultOp = this.getParameter("op");
        if (defaultOp != null) {
            if (defaultOp.compareToIgnoreCase("or") == 0) {
                this.searchFilter.bDefaultAnd = false;
            } else if (defaultOp.compareToIgnoreCase("ph") == 0) {
                bPhraseMode = true;
            }
        }
        int paramCount = this.getParameterCount();
        int i = 0;
        while (i < paramCount) {
            Str name = new Str();
            Str value = new Str();
            if (this.getParameterFromIndex(i, name, value) && Str.indexOfNoCase(name.s, "fq") == 0) {
                query = String.valueOf(query) + " {QF" + name.s.substring(2) + "} " + value.s;
            }
            ++i;
        }
        if (bPhraseMode && !query.startsWith("\"") && !query.endsWith("\"")) {
            query = "\"" + query + "\"";
        }
        int firstRes = 0;
        int resCount = 10;
        int sortType = 0;
        try {
            if (query != null) {
                query = URLDecoder.decode(query, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        firstRes = General.stringToInt(this.getParameter("strt"));
        sortType = General.stringToInt(this.getParameter("sort"));
        resCount = General.stringToInt(this.getParameter("cnt"));
        this.searchFilter.setPrevValidDayCount(General.stringToInt(this.getParameter("pvdc")));
        this.searchFilter.setValidDocTypes(General.stringToInt(this.getParameter("vdt")));
        if (resCount == 0) {
            resCount = 10;
        }
        this.searchSettings = new SearchSettings(basePath);
        this.params.queryString = query;
        this.params.count = resCount;
        this.params.first = firstRes;
        this.params.prefixString = prefix;
        this.params.sortType = sortType;
        this.params.searchFilter = this.searchFilter;
        this.params.scriptName = pagePath;
        String encoding = this.getParameter("enc");
        if (encoding != null && encoding.length() > 0) {
            if (encoding.compareToIgnoreCase("iso-8859-1") == 0) {
                this.params.codepage = 28591;
            }
        } else {
            String ae = this.getParameter("ae");
            try {
                if (ae != null) {
                    ae = URLDecoder.decode(ae, "UTF-8");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ae != null && ae.length() > 0 && ae.charAt(0) == '\u00df') {
                this.params.codepage = 28591;
            }
        }
    }
}

