/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.General;
import com.xtreeme.search.SearchFilter;
import com.xtreeme.search.Str;
import java.util.Date;
import java.util.GregorianCalendar;

public class ResultInfo {
    int sizeFlags;
    int sizeFraction;
    int sizeMain;
    int dateYear;
    int dateMonth;
    int dateDay;
    int score;
    String URL;
    int URLID;
    String title;
    String description;
    int docType;
    static final int DOC_NONE = 0;
    static final int DOC_PDF = 1;
    static final int DOC_DOC = 2;
    static final int DOC_XLS = 4;
    static final int DOC_PPT = 8;
    static final int DOC_OTHER = 16;
    static final int DOC_MEDIA = 32;
    static final int DOC_ARCHIVE = 64;

    int getDocType() {
        return this.docType;
    }

    void setDocType(int t) {
        this.docType = t;
    }

    static int getDateDifference(int y1, int m1, int d1, int y2, int m2, int d2) {
        GregorianCalendar startDate = new GregorianCalendar();
        startDate.set(y1, m1 - 1, d1);
        GregorianCalendar endDate = new GregorianCalendar();
        endDate.set(y2, m2 - 1, d2);
        int difInDays = (int)((endDate.getTimeInMillis() - startDate.getTimeInMillis()) / 86400000L);
        if (difInDays < 0) {
            return -difInDays;
        }
        return difInDays;
    }

    static boolean isDocumentRecent(int year, int month, int day, int prevValidDayCount) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTime(new Date());
        long filterTimeRaw = currentDate.getTimeInMillis() - 86400000L * (long)prevValidDayCount;
        GregorianCalendar filterTime = new GregorianCalendar();
        filterTime.setTimeInMillis(filterTimeRaw);
        if (year < filterTime.get(1)) {
            return false;
        }
        if (year == filterTime.get(1)) {
            if (month < filterTime.get(2) + 1) {
                return false;
            }
            if (month == filterTime.get(2) + 1 && day < filterTime.get(5)) {
                return false;
            }
        }
        return true;
    }

    static int getDocTypeFromURL(String URL2, boolean bStripParams) {
        int documentType = 16;
        String documentExtension = General.getExtensionFromURL(URL2, bStripParams);
        if (documentExtension != null && documentExtension.length() > 0) {
            if (documentExtension.equalsIgnoreCase("pdf")) {
                documentType = 1;
            } else if (documentExtension.equalsIgnoreCase("doc") || documentExtension.equalsIgnoreCase("rtf") || documentExtension.equalsIgnoreCase("dot") || documentExtension.equalsIgnoreCase("wpd") || documentExtension.equalsIgnoreCase("ps") || documentExtension.equalsIgnoreCase("odt") || documentExtension.equalsIgnoreCase("chm")) {
                documentType = 2;
            } else if (documentExtension.equalsIgnoreCase("xls") || documentExtension.equalsIgnoreCase("ods")) {
                documentType = 4;
            } else if (documentExtension.equalsIgnoreCase("ppt") || documentExtension.equalsIgnoreCase("pps") || documentExtension.equalsIgnoreCase("odp")) {
                documentType = 8;
            } else if (documentExtension.equalsIgnoreCase("gz") || documentExtension.equalsIgnoreCase("tar") || documentExtension.equalsIgnoreCase("taz") || documentExtension.equalsIgnoreCase("tgz") || documentExtension.equalsIgnoreCase("z") || documentExtension.equalsIgnoreCase("zip")) {
                documentType = 64;
            } else if (documentExtension.equalsIgnoreCase("avi") || documentExtension.equalsIgnoreCase("jpg") || documentExtension.equalsIgnoreCase("mov") || documentExtension.equalsIgnoreCase("mp3") || documentExtension.equalsIgnoreCase("ogg") || documentExtension.equalsIgnoreCase("png") || documentExtension.equalsIgnoreCase("rm") || documentExtension.equalsIgnoreCase("swf") || documentExtension.equalsIgnoreCase("wma") || documentExtension.equalsIgnoreCase("wmv") || documentExtension.equalsIgnoreCase("ram")) {
                documentType = 32;
            }
        }
        return documentType;
    }

    static boolean checkResultAgainstFilter(boolean bDemo, ResultInfo result, SearchFilter searchFilter) {
        int type;
        if (searchFilter.prevValidDayCount > 0 && !ResultInfo.isDocumentRecent(result.dateYear, result.dateMonth, result.dateDay, searchFilter.prevValidDayCount)) {
            return false;
        }
        if (searchFilter.validDocTypes != 0 && (searchFilter.validDocTypes & (type = result.getDocType())) == 0) {
            return false;
        }
        if (searchFilter.URLGroup != null && searchFilter.URLGroup.length() > 0) {
            int desPos;
            String url = result.URL;
            if (bDemo && (desPos = result.URL.indexOf("url=")) != -1) {
                url = result.URL.substring(4);
            }
            if (!Str.findStringInList(url, searchFilter.URLGroup, "\\*")) {
                return false;
            }
        }
        return true;
    }
}

