/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.General;
import com.xtreeme.search.HTMLCodeOutput;
import com.xtreeme.search.KeywordInfo;
import com.xtreeme.search.ParameterReader;
import com.xtreeme.search.ResultInfo;
import com.xtreeme.search.SearchEngineBase;
import com.xtreeme.search.SearchInfo;
import com.xtreeme.search.SearchSettings;
import com.xtreeme.search.Str;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResultOutput {
    SearchInfo si;
    HTMLCodeOutput codeOutput;
    SearchSettings searchSettings;
    private static final int CQUERYMINQUERYSIZE = 10;
    public static final int CQUERYMAXQUERYSIZE = 5120;
    private static final int CQUERYMAXSCREENSIZE = 100;

    public ResultOutput(SearchInfo searchInfo, SearchSettings settings, HTMLCodeOutput output) {
        this.si = searchInfo;
        this.codeOutput = output;
        this.searchSettings = settings;
    }

    private static String overviewResolveConditionalCommands(int currentPageNumber, int lastPageNumber, String resultTemplateText) {
        int tempInt2;
        int tempInt;
        String resultTemplate = resultTemplateText;
        while ((tempInt = resultTemplate.indexOf("{{IF")) != -1 && (tempInt2 = resultTemplate.indexOf("|", tempInt)) != -1) {
            int tempInt3 = resultTemplate.indexOf("}}", tempInt);
            int tempInt4 = resultTemplate.indexOf("{{IF", tempInt + 4);
            if (tempInt4 != -1 && tempInt3 != -1 && tempInt4 < tempInt3) {
                tempInt4 = tempInt3 + 2 - tempInt;
                tempInt3 = resultTemplate.indexOf("}}", tempInt + tempInt4);
            }
            if (tempInt3 == -1 || tempInt3 <= tempInt2) break;
            boolean bInclude = false;
            if (resultTemplate.charAt((tempInt += 6) - 2) == 'N' && resultTemplate.charAt(tempInt - 1) == 'L') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                if (tempInt4 < 0) {
                    tempInt4 = 0;
                }
                bInclude = currentPageNumber < lastPageNumber - tempInt4;
            } else if (resultTemplate.charAt(tempInt - 2) == 'G' && resultTemplate.charAt(tempInt - 1) == 'T') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = currentPageNumber > tempInt4 - 1;
            } else if (resultTemplate.charAt(tempInt - 2) == 'L' && resultTemplate.charAt(tempInt - 1) == 'A') {
                bInclude = currentPageNumber == lastPageNumber;
            } else if (resultTemplate.charAt(tempInt - 2) == 'E' && resultTemplate.charAt(tempInt - 1) == 'X') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = tempInt4 - 1 <= lastPageNumber;
            } else if (resultTemplate.charAt(tempInt - 2) == 'N' && resultTemplate.charAt(tempInt - 1) == 'E') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = tempInt4 - 1 > lastPageNumber;
            } else if (resultTemplate.charAt(tempInt - 2) == 'P' && resultTemplate.charAt(tempInt - 1) == 'G') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = currentPageNumber == tempInt4 - 1;
            } else if (resultTemplate.charAt(tempInt - 2) == 'N' && resultTemplate.charAt(tempInt - 1) == 'P') {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = currentPageNumber != tempInt4 - 1;
            }
            String includedCode = new String();
            if (bInclude) {
                includedCode = resultTemplate.substring(tempInt2 + 1, tempInt3);
            }
            String remainingCode = resultTemplate.substring(tempInt3 + 2);
            resultTemplate = String.valueOf(resultTemplate.substring(0, tempInt - 6)) + includedCode + remainingCode;
        }
        return resultTemplate;
    }

    private static String createPageLink(int nPage, ParameterReader paramReader, String basePath) {
        String retval = paramReader.params.scriptName;
        retval = String.valueOf(retval) + "?";
        boolean bFirst = true;
        boolean bstrtSet = false;
        boolean bmodeSet = false;
        boolean bwrapSet = false;
        int nParams = paramReader.getParameterCount();
        int i = 0;
        while (i < nParams) {
            block10: {
                Str value;
                Str name;
                block12: {
                    block13: {
                        block11: {
                            name = new Str();
                            value = new Str();
                            if (!paramReader.getParameterFromIndex(i, name, value)) break block10;
                            if (name.s.compareToIgnoreCase("strt") != 0) break block11;
                            value.s = Integer.toString(nPage * paramReader.params.count);
                            bstrtSet = true;
                            break block12;
                        }
                        if (name.s.compareToIgnoreCase("mode") != 0) break block13;
                        value.s = "java";
                        bmodeSet = true;
                        break block12;
                    }
                    if (name.s.compareToIgnoreCase("wrap") != 0) break block12;
                    if (bwrapSet) break block10;
                    bwrapSet = true;
                }
                if (value.s.length() > 0) {
                    if (!bFirst) {
                        retval = String.valueOf(retval) + "&";
                    }
                    retval = String.valueOf(retval) + name.s + "=" + value.s;
                }
                bFirst = false;
            }
            ++i;
        }
        if (!bmodeSet) {
            if (!bFirst) {
                retval = String.valueOf(retval) + "&";
            }
            retval = String.valueOf(retval) + "mode=java";
            bFirst = false;
        }
        if (!bstrtSet) {
            if (!bFirst) {
                retval = String.valueOf(retval) + "&";
            }
            retval = String.valueOf(retval) + "strt=" + Integer.toString(nPage * paramReader.params.count);
            bFirst = false;
        }
        return retval;
    }

    private static String overviewReplaceSpecialStrings(int maxResults, int currentPageNumber, int lastPage, int resultCount, ParameterReader paramReader, String resultTemplateText, String basePath) {
        int searchPos;
        String resultTemplate = resultTemplateText;
        int lastResult = currentPageNumber * paramReader.params.count + paramReader.params.count;
        if (lastResult > resultCount) {
            lastResult = resultCount;
        }
        String resultCountStr = resultCount < maxResults ? Integer.toString(resultCount) : "&gt;" + Integer.toString(maxResults);
        resultTemplate = Str.replaceAll("(resultcount)", resultCountStr, resultTemplate);
        resultTemplate = Str.replaceAll("(firstresult)", Integer.toString(currentPageNumber * paramReader.params.count + 1), resultTemplate);
        resultTemplate = Str.replaceAll("(lastresult)", Integer.toString(lastResult), resultTemplate);
        resultTemplate = Str.replaceAll("(resultsperpage)", Integer.toString(paramReader.params.count), resultTemplate);
        resultTemplate = Str.replaceAll("(currentpage)", Integer.toString(currentPageNumber + 1), resultTemplate);
        resultTemplate = Str.replaceAll("(lastpage)", Integer.toString(lastPage + 1), resultTemplate);
        resultTemplate = Str.replaceAll("(searchquery)", paramReader.params.queryString, resultTemplate);
        resultTemplate = Str.replaceAll("(linkprev)", ResultOutput.createPageLink(currentPageNumber - 1, paramReader, basePath), resultTemplate);
        resultTemplate = Str.replaceAll("(linknext)", ResultOutput.createPageLink(currentPageNumber + 1, paramReader, basePath), resultTemplate);
        int nPage = 0;
        while (nPage <= lastPage) {
            resultTemplate = Str.replaceAll("(linkpage" + Integer.toString(nPage + 1) + ")", ResultOutput.createPageLink(nPage, paramReader, basePath), resultTemplate);
            if (resultTemplate.indexOf("(linkpage") == -1) break;
            ++nPage;
        }
        int prevSearchPos = -1;
        while ((searchPos = resultTemplate.indexOf("(nbpage")) != -1 && searchPos > prevSearchPos) {
            int pageNumber;
            String repString;
            prevSearchPos = searchPos;
            int endPos = resultTemplate.indexOf(")", searchPos + 7);
            if (endPos == -1) break;
            int offset = Integer.parseInt(resultTemplate.substring(searchPos + 9, endPos));
            if (resultTemplate.charAt(prevSearchPos + 7) == 'L') {
                repString = resultTemplate.charAt(prevSearchPos + 8) == 'P' ? ResultOutput.createPageLink(currentPageNumber - offset, paramReader, basePath) : ResultOutput.createPageLink(currentPageNumber + offset, paramReader, basePath);
            } else if (resultTemplate.charAt(prevSearchPos + 8) == 'P') {
                pageNumber = currentPageNumber + 1 - offset;
                if (pageNumber < 0) {
                    pageNumber = 0;
                }
                repString = Integer.toString(pageNumber);
            } else {
                pageNumber = currentPageNumber + 1 + offset;
                repString = Integer.toString(pageNumber);
            }
            if (repString.length() <= 0) break;
            resultTemplate = Str.replaceAll(resultTemplate.substring(searchPos, endPos + 1), repString, resultTemplate);
        }
        return resultTemplate;
    }

    private static String processOverviewCode(int maxResults, int currentPageNumber, int resultCount, ParameterReader paramReader, String resultBuffer, String basePath) {
        int lastPage = resultCount % paramReader.params.count != 0 ? resultCount / paramReader.params.count : resultCount / paramReader.params.count - 1;
        String resultCode = ResultOutput.overviewResolveConditionalCommands(currentPageNumber, lastPage, resultBuffer);
        if (resultCount > 0) {
            resultCode = ResultOutput.overviewReplaceSpecialStrings(maxResults, currentPageNumber, lastPage, resultCount, paramReader, resultCode, basePath);
        }
        return resultCode;
    }

    static String makeSearchKeywordsBold(List keywordList, String str) {
        String currentExpression = new String();
        String string = str;
        Iterator i = keywordList.iterator();
        while (i.hasNext()) {
            String word;
            KeywordInfo keyword = (KeywordInfo)i.next();
            if (keyword.expressionPos > 0 && keyword.expressionId != 0) {
                if (!keyword.bExpressionEnd) {
                    currentExpression = String.valueOf(currentExpression) + keyword.keyword + ' ';
                    word = new String();
                } else {
                    word = String.valueOf(currentExpression) + keyword.keyword;
                    currentExpression = new String();
                }
            } else {
                word = keyword.keyword;
            }
            if (word == null || word.length() <= 0) continue;
            String lowKey = word;
            String strLower = string.toLowerCase();
            int n = strLower.indexOf(lowKey);
            if (n == -1) continue;
            String rep = "<span class='b'>" + string.substring(n, n + word.length()) + "</span>";
            string = Str.replaceNoCase(word, rep, string, true);
        }
        return string;
    }

    static String resultReplaceDateString(String resultTemplateString, ResultInfo currentResult) {
        String resultTemplate = resultTemplateString;
        int tempInt = -1;
        while (true) {
            String buf;
            int tempInt2;
            int tempInt3 = tempInt;
            tempInt = resultTemplate.indexOf("(docdate");
            if (tempInt == -1 || tempInt <= tempInt3 || (tempInt2 = resultTemplate.indexOf(")", tempInt)) == -1) break;
            tempInt += 8;
            if (currentResult.dateYear > 0) {
                buf = resultTemplate.substring(tempInt, tempInt2);
                buf = Str.replaceAll("DD", Integer.toString(currentResult.dateDay), buf);
                buf = Str.replaceAll("YYYY", Integer.toString(currentResult.dateYear), buf);
                buf = Str.replaceAll("MMM", General.getMonthString(currentResult.dateMonth), buf);
                buf = Str.replaceAll("MM", Integer.toString(currentResult.dateMonth), buf);
            } else {
                buf = new String();
            }
            String replaceSrc = resultTemplate.substring(tempInt - 8, tempInt2 + 1);
            resultTemplate = Str.replaceAll(replaceSrc, buf, resultTemplate);
        }
        return resultTemplate;
    }

    static String resultReplaceSizeString(String resultTemplateString, ResultInfo currentResult) {
        String resultTemplate = resultTemplateString;
        String sizeFr = Integer.toString(currentResult.sizeFraction < 10 ? currentResult.sizeFraction : 0);
        String size = Integer.toString(currentResult.sizeMain);
        if (currentResult.sizeFlags != 0 && currentResult.sizeFlags != 1) {
            size = String.valueOf(size) + "." + sizeFr;
        }
        if (currentResult.sizeFlags == 1) {
            size = String.valueOf(size) + "KB";
        }
        if (currentResult.sizeFlags == 2) {
            size = String.valueOf(size) + "MB";
        }
        if (currentResult.sizeFlags == 3) {
            size = String.valueOf(size) + "GB";
        }
        resultTemplate = Str.replaceAll("(docsize)", size, resultTemplate);
        return resultTemplate;
    }

    static String GetQueryWordList(List keywordList) {
        String str = new String();
        Iterator i = keywordList.iterator();
        int nWord = 0;
        while (i.hasNext()) {
            KeywordInfo keyword = (KeywordInfo)i.next();
            if (keyword.keyword == null || keyword.keyword.length() <= 0) continue;
            if (nWord > 0) {
                str = String.valueOf(str) + ' ';
            }
            str = String.valueOf(str) + keyword.keyword;
            ++nWord;
        }
        return str;
    }

    static String resultReplaceSpecialStrings(int currentResultNumber, int docKind, List keywordList, String contents, String targetFrame, String resultTemplateText, ResultInfo currentResult) {
        String resultTemplate = resultTemplateText;
        String docType = "HTML";
        String docName = General.getFilenameFromPath(currentResult.URL);
        if (docKind == 1) {
            docType = "PDF";
        } else if (docKind == 2) {
            docType = "Text";
        } else if (docKind == 4) {
            docType = "Spreadsheet";
        } else if (docKind == 8) {
            docType = "Presentation";
        } else if (docKind == 64) {
            docType = "Archive";
        } else if (docKind == 32) {
            docType = "Media";
        }
        String curURL = docKind == 1 ? String.valueOf(currentResult.URL) + "#search='" + ResultOutput.GetQueryWordList(keywordList) + "'" : currentResult.URL;
        resultTemplate = Str.replaceAll("(URLEx)", curURL, resultTemplate);
        resultTemplate = Str.replaceAll("(URL)", currentResult.URL, resultTemplate);
        String buf = currentResult.description;
        buf = ResultOutput.makeSearchKeywordsBold(keywordList, buf);
        resultTemplate = Str.replaceAll("(docdesc)", buf, resultTemplate);
        buf = currentResult.title.length() == 0 ? currentResult.URL : currentResult.title;
        buf = ResultOutput.makeSearchKeywordsBold(keywordList, buf);
        resultTemplate = Str.replaceAll("(doctitle)", buf, resultTemplate);
        resultTemplate = Str.replaceAll("(doctype)", docType, resultTemplate);
        resultTemplate = Str.replaceAll("(docname)", docName, resultTemplate);
        resultTemplate = Str.replaceAll("(resnumber)", Integer.toString(currentResultNumber), resultTemplate);
        resultTemplate = Str.replaceAll("(trgframe)", targetFrame, resultTemplate);
        resultTemplate = Str.replaceAll("(doccontents)", contents.length() > 0 ? contents : " ", resultTemplate);
        resultTemplate = ResultOutput.resultReplaceDateString(resultTemplate, currentResult);
        resultTemplate = ResultOutput.resultReplaceSizeString(resultTemplate, currentResult);
        return resultTemplate;
    }

    static String resultResolveConditionalCommands(int docKind, String resultTemplateText, ResultInfo currentResult) {
        int tempInt2;
        int tempInt;
        String resultTemplate = resultTemplateText;
        while ((tempInt = resultTemplate.indexOf("{{IF")) != -1 && (tempInt2 = resultTemplate.indexOf("|", tempInt)) != -1) {
            int tempInt3 = resultTemplate.indexOf("}}", tempInt);
            int tempInt4 = resultTemplate.indexOf("{{IF", tempInt + 4);
            if (tempInt4 != -1 && tempInt3 != -1 && tempInt4 < tempInt3) {
                tempInt4 = tempInt3 + 2 - tempInt;
                tempInt3 = resultTemplate.indexOf("}}", tempInt + tempInt4);
            }
            if (tempInt3 == -1 || tempInt3 <= tempInt2) break;
            boolean bInclude = false;
            if (resultTemplate.charAt((tempInt += 6) - 2) == 'D') {
                boolean tempBool = resultTemplate.charAt(tempInt - 1) == '-';
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = ResultInfo.isDocumentRecent(currentResult.dateYear, currentResult.dateMonth, currentResult.dateDay, tempInt4);
                if (tempBool) {
                    bInclude = !bInclude;
                }
            } else {
                tempInt4 = Integer.parseInt(resultTemplate.substring(tempInt, tempInt2));
                bInclude = (tempInt4 & docKind) != 0;
            }
            String includedCode = new String();
            if (bInclude) {
                includedCode = resultTemplate.substring(tempInt2 + 1, tempInt3);
            }
            String remainingCode = resultTemplate.substring(tempInt3 + 2);
            resultTemplate = String.valueOf(resultTemplate.substring(0, tempInt - 6)) + includedCode + remainingCode;
        }
        return resultTemplate;
    }

    private String processResultCode(ResultInfo currentResult, int currentResultNumber, String resultBuffer, String contents, String targetFrame, List keywordList) {
        int docKind = currentResult.getDocType();
        String code = ResultOutput.resultResolveConditionalCommands(docKind, resultBuffer, currentResult);
        code = ResultOutput.resultReplaceSpecialStrings(currentResultNumber, docKind, keywordList, contents, targetFrame, code, currentResult);
        return code;
    }

    private void printNormalResult(List keywordList, ResultInfo currentResult, int nResult, int firstResult) {
        String resultTemplate = this.searchSettings.resultFormatText;
        Str titleStr = new Str();
        Str descStr = new Str();
        this.si.getTitleAndDescriptionFromURLID(currentResult.URLID, titleStr, descStr);
        currentResult.title = titleStr.s;
        currentResult.description = descStr.s;
        Str contents = new Str();
        if (resultTemplate.indexOf("(doccontents)") != -1 && this.si.contentsDB.isInitialized() && this.si.contentsIndexDB.isInitialized() && this.si.keywordIndex2DB.isInitialized()) {
            SearchEngineBase.getDescriptionFromContents(this.si, keywordList, currentResult.URLID, this.searchSettings.contentPreviewBlockCount, this.searchSettings.contentPreviewBlockSize, contents);
            contents.s = String.valueOf(contents.s) + "...";
        }
        String resultCode = this.processResultCode(currentResult, nResult + firstResult, resultTemplate, contents.s, this.searchSettings.defaultFrame, keywordList);
        this.codeOutput.printToOutputBuffer(resultCode);
    }

    public void showResults(ParameterReader paramReader, ArrayList resultList, List keywordList, String basePath) {
        int totalResults;
        int maxResults = this.searchSettings.maxResults;
        if (maxResults < 10) {
            maxResults = 10;
        }
        if (maxResults > 5120) {
            maxResults = 5120;
        }
        if (paramReader.params.count > 100) {
            paramReader.params.count = 100;
        }
        if (paramReader.params.count == 0) {
            paramReader.params.count = 1;
        }
        if (paramReader.params.first >= (totalResults = resultList.size())) {
            paramReader.params.first = 0;
        }
        int cSkipResults = paramReader.params.first;
        if (totalResults == 0) {
            this.codeOutput.printToOutputBuffer("\n<br>");
            this.codeOutput.printToOutputBuffer(this.searchSettings.fontStr);
            this.codeOutput.printToOutputBuffer(this.searchSettings.noResultsStr);
            this.codeOutput.printToOutputBuffer(this.searchSettings.fontEndStr);
        } else {
            try {
                String overviewCode = ResultOutput.processOverviewCode(maxResults, paramReader.params.first / paramReader.params.count, totalResults, paramReader, this.searchSettings.resultOverviewText, basePath);
                int markerPos = overviewCode.indexOf("(resultcode)");
                if (markerPos != -1) {
                    this.codeOutput.printToOutputBuffer(overviewCode.substring(0, markerPos));
                    int cCurrentResult = 0;
                    int i = 0;
                    while (i < resultList.size() && cCurrentResult < paramReader.params.count) {
                        ResultInfo result = (ResultInfo)resultList.get(i);
                        if (cSkipResults > 0) {
                            --cSkipResults;
                        } else {
                            this.printNormalResult(keywordList, result, cCurrentResult + 1, paramReader.params.first);
                            ++cCurrentResult;
                        }
                        ++i;
                    }
                    this.codeOutput.printToOutputBuffer(overviewCode.substring(markerPos + 12));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

