/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.AdvSearchEngine;
import com.xtreeme.search.AppletCodeOutput;
import com.xtreeme.search.AppletParameterReader;
import com.xtreeme.search.DebugOutput;
import com.xtreeme.search.HTMLCodeOutput;
import com.xtreeme.search.ParameterReader;
import com.xtreeme.search.ResultOutput;
import com.xtreeme.search.SearchInfo;
import java.applet.Applet;
import java.net.URLDecoder;
import java.util.ArrayList;

public class SESSearchApplet
extends Applet {
    private HTMLCodeOutput codeOutput;

    public void init() {
        try {
            String outputMethod = this.getParameter("DEBUG");
            this.codeOutput = outputMethod == null || outputMethod.length() == 0 ? new AppletCodeOutput(this) : new DebugOutput();
            String basePath = this.getParameter("basepath");
            if ((basePath == null || basePath.length() == 0) && (basePath = this.getCodeBase().toString()) != null) {
                int fileIndex;
                if (basePath.indexOf("file:/") != -1) {
                    basePath = basePath.length() > 7 && basePath.charAt(6) != '/' && basePath.charAt(7) != ':' ? basePath.substring(5) : basePath.substring(6);
                }
                if ((fileIndex = basePath.indexOf("sessearch.htm")) != -1) {
                    basePath = basePath.substring(0, fileIndex);
                }
            }
            try {
                basePath = URLDecoder.decode(basePath, "UTF-8");
            }
            catch (Exception fileIndex) {
                // empty catch block
            }
            AppletParameterReader reader = new AppletParameterReader();
            reader.loadParametersFromApplet(this);
            reader.readParameters(basePath);
            this.performSearch(reader, basePath);
            this.codeOutput.flush();
        }
        catch (Exception e) {
            System.err.println("error: " + e.toString());
        }
    }

    public void performSearch(ParameterReader paramReader, String dataPath) {
        SearchInfo si = new SearchInfo();
        if (!si.initialize(dataPath, paramReader.params.prefixString)) {
            this.codeOutput.printToOutputBuffer("\n<br>Error: cannot open database files in " + dataPath + ".<p>");
            si.cleanUp();
            return;
        }
        si.setDemoVersion(paramReader.searchSettings.getDemoVersion());
        AdvSearchEngine searchEngine = new AdvSearchEngine(si, paramReader.searchSettings.getMinLen(), paramReader.searchSettings.getMaxResults(), paramReader.params.prefixString, paramReader.params.searchFilter);
        ArrayList resultList = new ArrayList();
        ArrayList keywordList = new ArrayList();
        searchEngine.searchStart(paramReader.params.queryString, paramReader.params.sortType, paramReader.searchSettings.specialChars, resultList, keywordList, paramReader.params.codepage);
        ResultOutput resultOutput = new ResultOutput(si, paramReader.searchSettings, this.codeOutput);
        resultOutput.showResults(paramReader, resultList, keywordList, dataPath);
        si.cleanUp();
    }
}

