/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.AdvSearchEngine;
import com.xtreeme.search.General;
import com.xtreeme.search.ParameterReader;
import com.xtreeme.search.ResultOutput;
import com.xtreeme.search.SearchInfo;
import com.xtreeme.search.ServletCodeOutput;
import com.xtreeme.search.ServletParameterReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SESSearchServlet
extends HttpServlet {
    private ServletCodeOutput codeOutput;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runSearch(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runSearch(req, resp);
    }

    private void runSearch(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.codeOutput = new ServletCodeOutput(resp);
            String basePath = req.getParameter("basepath");
            if (basePath == null) {
                basePath = this.getServletContext().getRealPath("/WEB-INF/lib/");
                if (!General.doesFileExist(String.valueOf(basePath) + (basePath.endsWith("/") ? "" : "/") + "sessearch.t")) {
                    basePath = this.getServletContext().getRealPath("/");
                }
                if (basePath == null) {
                    basePath = new String();
                }
            }
            if (basePath.length() > 0 && !basePath.endsWith("/")) {
                basePath = String.valueOf(basePath) + '/';
            }
            ServletParameterReader reader = new ServletParameterReader();
            reader.setParameterSource(req);
            reader.readParameters(basePath);
            String prefix = req.getParameter("pref");
            this.printFileContents(basePath, prefix, "header.htm");
            this.performSearch(reader, basePath);
            this.printFileContents(basePath, prefix, "footer.htm");
            this.codeOutput.flush();
        }
        catch (Exception e) {
            System.err.println("error: " + e.toString());
        }
    }

    void printFileContents(String basePath, String prefix, String name) {
        try {
            String line;
            String filePath = String.valueOf(basePath) + (prefix != null && prefix.length() > 0 ? prefix : "") + name;
            if (!General.doesFileExist(filePath)) {
                filePath = String.valueOf(basePath) + name;
            }
            RandomAccessFile file = new RandomAccessFile(filePath, "r");
            while ((line = file.readLine()) != null) {
                this.codeOutput.printToOutputBuffer(String.valueOf(line) + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void performSearch(ParameterReader paramReader, String dataPath) {
        SearchInfo si = new SearchInfo();
        if (!si.initialize(dataPath, paramReader.params.prefixString)) {
            this.codeOutput.printToOutputBuffer("\n<br>Error: cannot open database files in " + dataPath + ".<p>");
            si.cleanUp();
            return;
        }
        si.setDemoVersion(paramReader.searchSettings.getDemoVersion());
        AdvSearchEngine searchEngine = new AdvSearchEngine(si, paramReader.searchSettings.getMinLen(), paramReader.searchSettings.getMaxResults(), paramReader.params.prefixString, paramReader.params.searchFilter);
        ArrayList resultList = new ArrayList();
        ArrayList keywordList = new ArrayList();
        searchEngine.searchStart(paramReader.params.queryString, paramReader.params.sortType, paramReader.searchSettings.specialChars, resultList, keywordList, paramReader.params.codepage);
        ResultOutput resultOutput = new ResultOutput(si, paramReader.searchSettings, this.codeOutput);
        resultOutput.showResults(paramReader, resultList, keywordList, dataPath);
        si.cleanUp();
    }
}

