/*
 * Decompiled with CFR 0.152.
 */
package com.xtreeme.search;

import com.xtreeme.search.Int;
import com.xtreeme.search.SDBInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessControlException;

public class SearchSettings {
    private static final int FONTINFOSIZE = 128;
    private static final int FONTENDINFOSIZE = 16;
    private static final int PREFIXSIZE = 11;
    private static final int NFONTS = 5;
    private static final int BINDATASIZE = 20;
    private static final int NSTRINGS = 7;
    private static final int STRINGSIZE = 256;
    private static final int LONGSTRINGSIZE = 2048;
    private static final int RESULTFORMATSIZE = 16384;
    private static final int RESULTOVERVIEWSIZE = 16384;
    private static final int RESULTBUFFERMAXSIZE = 16384;
    private static final int NEWSETTINGSSIZE = 32770;
    public static final int CSPECIALCHARS = 91;
    public static final int NEWSPECIALCHARSIZE = 14;
    public static final int NEWSPECIALCHARACTERSSIZE = 1274;
    public static final int OLDSPECIALCHARACTERSSIZE = 300;
    public static final int CODEPAGE_UTF8 = 65001;
    public static final int CODEPAGE_ANSI = 28591;
    private static final int FONT1ENDOFFSET = 11;
    private static final int FONT1OFFSET = 91;
    private static final int MAXRESULTSOFFSET = 733;
    private static final int MINLENOFFSET = 739;
    private static final int NORESULTSOFFSET = 2031;
    private static final int DEFAULTFRAMEOFFSET = 2287;
    private static final int OLDSPECIALCHARACTERSOFFSET = 2543;
    private static final int NEWDATAOFFSET = 4891;
    private static final int RESULTFORMATOFFSET = 4891;
    private static final int CONTENTPREVIEWBLOCKCOUNTOFFSET = 21275;
    private static final int CONTENTPREVIEWBLOCKSIZEOFFSET = 21276;
    private static final int RESULTOVERVIEWTEXTOFFSET = 21277;
    private static final int SEGMENT64OFFSET = 27;
    private static final int VERSIONMINOROFFSET = 27;
    private static final int VERSIONMAJOROFFSET = 28;
    private static final int VERSIONBUILDOFFSET = 29;
    private static final int DEMOOFFSET = 30;
    private static final int NEWSPECIALCHARACTERSOFFSET = 751;
    String fontStr;
    String fontEndStr;
    int maxResults;
    int minLen;
    String noResultsStr;
    String defaultFrame;
    String resultFormatText;
    int contentPreviewBlockSize;
    int contentPreviewBlockCount;
    String resultOverviewText;
    boolean bDemo;
    public char[] specialChars = new char[1274];

    public SearchSettings(String path) {
        try {
            RandomAccessFile file = new RandomAccessFile(String.valueOf(path) + "sessearch.t", "r");
            this.fontEndStr = this.readStringSetting(file, 11, 16);
            this.fontStr = this.readStringSetting(file, 91, 128);
            this.maxResults = this.readIntSetting(file, 733, 2);
            this.minLen = this.readIntSetting(file, 739, 1);
            this.noResultsStr = this.readStringSetting(file, 2031, 256);
            this.defaultFrame = this.readStringSetting(file, 2287, 256);
            this.resultFormatText = this.readStringSetting(file, 4891, 16384);
            this.contentPreviewBlockSize = this.readIntSetting(file, 21276, 1);
            this.contentPreviewBlockCount = this.readIntSetting(file, 21275, 1);
            this.resultOverviewText = this.readStringSetting(file, 21277, 16384);
            this.readSpecialCharSetting(file, this.specialChars, 751, 1274);
            file.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: cannot read file " + path);
        }
        catch (IOException e) {
            System.err.println("Error: error reading file " + path);
        }
        catch (AccessControlException e) {
            System.err.println("Error: no access to read file " + path);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Error: error reading file " + path + " (out of bounds exception)");
        }
        catch (Exception e) {
            System.err.println("Error: reading file " + path);
        }
    }

    public boolean getDemoVersion() {
        return this.bDemo;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    String readStringSetting(RandomAccessFile file, int offset, int size) {
        byte[] bytes = new byte[size];
        try {
            file.seek(offset);
            file.readFully(bytes);
        }
        catch (Exception e) {
            System.err.println("Error: error reading settings file @" + offset);
        }
        int bytesSize = size;
        int i = 0;
        while (i < size) {
            if (bytes[i] == 0) {
                bytesSize = i;
                break;
            }
            ++i;
        }
        String str = new String(bytes, 0, bytesSize);
        return str;
    }

    int readIntSetting(RandomAccessFile file, int offset, int size) {
        try {
            file.seek(offset);
            Int retval = new Int(0);
            boolean result = SDBInfo.getMultiByteNumber(file, size, retval);
            return retval.i;
        }
        catch (Exception e) {
            System.err.println("Error: error reading settings file @" + offset);
            return 0;
        }
    }

    void readSpecialCharSetting(RandomAccessFile file, char[] chars, int offset, int size) {
        byte[] bytes = new byte[size];
        try {
            file.seek(offset);
            file.readFully(bytes);
            int i = 0;
            while (i < size) {
                chars[i] = (char)(bytes[i] & 0xFF);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error: error reading settings file @" + offset);
        }
    }
}

